/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.List;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.repository.RoleRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class RoleService {
    private final RoleRepository roleRepository;

    @Autowired
    public RoleService(RoleRepository roleRepository) {
        this.roleRepository = roleRepository;
    }

    @Transactional
    public void createRole(Role role) {
        this.roleRepository.saveAndFlush(role);
    }

    @Transactional
    public void update(Role role) {
        this.roleRepository.saveAndFlush(role);
    }

    @Transactional
    public void remove(Role role) {
        this.roleRepository.delete(role);
    }

    public List<Role> getAllRoles() {
        return this.roleRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public Role getRoleById(Long roleID) {
        return (Role)this.roleRepository.findOne(roleID);
    }

    public Role getRoleByName(String name) {
        return this.roleRepository.findByName(name);
    }

    public Role load(Long id) {
        return (Role)this.roleRepository.getOne(id);
    }
}

