/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.service;

import java.util.List;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.repository.WorkflowTypeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WorkflowTypeService {
    @Autowired
    private WorkflowTypeRepository workflowTypeRepository;

    public WorkflowTypes getEnabledWorkflowTypeByType(String type) {
        return this.workflowTypeRepository.findByTypeAndEnabledIsTrue(type);
    }

    public WorkflowTypes getWorkflowTypeByType(String type) {
        return this.workflowTypeRepository.findByType(type);
    }

    public List<WorkflowTypes> getAllWorkflowTypes() {
        return this.workflowTypeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"type"}));
    }

    public WorkflowTypes getWorkflowTypeById(Long id) {
        return (WorkflowTypes)this.workflowTypeRepository.findOne(id);
    }
}

