/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.utils;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonSerializer;
import java.util.Collection;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.support.json.adapter.HibernateProxyTypeAdapter;

public class WebUtils {
    private WebUtils() {
    }

    public static String extractRequestedDomainName(HttpServletRequest httpRequest) {
        String requestURL = httpRequest.getRequestURL().toString();
        return WebUtils.extractRequestedDomainName(requestURL);
    }

    public static String extractRequestedDomainName(String requestURL) {
        int domainNameStartIndex;
        int domainNameEndIndex = requestURL.indexOf(47, domainNameStartIndex = requestURL.indexOf("://") + 3);
        String domainName = requestURL.substring(domainNameStartIndex, domainNameEndIndex > 0 ? domainNameEndIndex : requestURL.length());
        if (domainName.contains(":")) {
            domainName = domainName.split(":")[0];
        }
        return domainName;
    }

    public static String extractRequestDomainURL(HttpServletRequest httpRequest, boolean withContext) {
        StringBuilder url = new StringBuilder(httpRequest.getRequestURL());
        String uri = httpRequest.getRequestURI();
        return withContext ? url.substring(0, url.length() - uri.length() + httpRequest.getContextPath().length()) + "/" : url.substring(0, url.length() - uri.length());
    }

    public static String extractQueryParamsFromUrl(String url) {
        return url.substring(url.indexOf(63) + 1, url.length());
    }

    public static String extractURLWithoutQueryParams(String url) {
        return url.substring(0, url.indexOf(63));
    }

    public static String currentContextPath(ServletRequest request) {
        return request.getServletContext().getContextPath().toUpperCase().replace("/", "");
    }

    public static <T> String toJSON(Collection<T> objects, Class<? extends T> objectClazz, Class<? extends JsonSerializer<T>> adptorClazz) {
        try {
            return new GsonBuilder().registerTypeAdapterFactory(HibernateProxyTypeAdapter.FACTORY).registerTypeAdapter(objectClazz, adptorClazz.newInstance()).create().toJson(objects);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ApplicationRuntimeException("Could not convert object list to json string", e);
        }
    }

    public static <T> String toJSON(T object, Class<? extends JsonSerializer<T>> adptorClazz) {
        try {
            return new GsonBuilder().registerTypeAdapterFactory(HibernateProxyTypeAdapter.FACTORY).registerTypeAdapter(object.getClass(), adptorClazz.newInstance()).create().toJson(object);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ApplicationRuntimeException("Could not convert object to json string", e);
        }
    }
}

