/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.struts.actions;

import org.displaytag.pagination.PaginatedList;
import org.displaytag.properties.SortOrderEnum;
import org.displaytag.util.ParamEncoder;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.utils.EgovPaginatedList;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.services.Page;

public abstract class SearchFormAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final String SORT_ORDER_ASCENDING = "asc";
    private static final String SORT_ORDER_DESCENDING = "desc";
    private static final String DEFAULT_TABLE_ID = "currentRowObject";
    private int pageNum = 1;
    private int pageSize = 20;
    private ParamEncoder paramEncoder = new ParamEncoder("currentRowObject");
    private String sortField;
    private SortOrderEnum sortOrder = SortOrderEnum.ASCENDING;
    private SearchQuery searchQuery;
    protected PaginatedList searchResult;

    public void setTableId(String tableId) {
        this.paramEncoder = new ParamEncoder(tableId);
    }

    public void setPage(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPage() {
        return this.pageNum;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getSort() {
        return this.sortField;
    }

    public void setSort(String sortField) {
        this.sortField = sortField;
    }

    public String getSortDir() {
        return this.sortOrder == SortOrderEnum.ASCENDING ? SORT_ORDER_ASCENDING : SORT_ORDER_DESCENDING;
    }

    public void setSortDir(String sortDir) {
        this.sortOrder = sortDir.equals(SORT_ORDER_ASCENDING) ? SortOrderEnum.ASCENDING : SortOrderEnum.DESCENDING;
    }

    public void setDir(String sortDir) {
        this.setSortDir(sortDir);
    }

    public String getDir() {
        return this.getSortDir();
    }

    public PaginatedList getSearchResult() {
        return this.searchResult;
    }

    public abstract SearchQuery prepareQuery(String var1, String var2);

    private boolean isExportMode() {
        return this.parameters.get(this.paramEncoder.encodeParameterName("e")) != null;
    }

    public String search() {
        if (this.searchQuery == null) {
            this.searchQuery = this.prepareQuery(this.sortField, this.getSortDir());
        }
        if (this.isExportMode()) {
            this.pageSize = -1;
            this.pageNum = 1;
        }
        Page resultPage = this.searchQuery.getPage(this.persistenceService, this.pageNum, this.pageSize);
        int searchCount = this.searchQuery.getCount(this.persistenceService);
        this.searchResult = new EgovPaginatedList(resultPage, searchCount, this.sortField, this.sortOrder);
        return "success";
    }
}

