/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.spring.handler;

import javax.servlet.http.HttpServletRequest;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.RedirectView;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    public static final String DEFAULT_ERROR_VIEW = "/error/500";

    @ExceptionHandler(value={Exception.class})
    public RedirectView defaultErrorHandler(HttpServletRequest req, Exception e) throws Exception {
        LOG.error("An error occurred while processing the request", (Throwable)e);
        if (AnnotationUtils.findAnnotation(e.getClass(), ResponseStatus.class) != null) {
            throw e;
        }
        return this.createErrorMV(req, e);
    }

    @ExceptionHandler(value={ApplicationRuntimeException.class})
    public RedirectView egovErrorHandler(HttpServletRequest req, ApplicationRuntimeException e) throws Exception {
        return this.createErrorMV(req, e);
    }

    private RedirectView createErrorMV(HttpServletRequest request, Exception e) {
        RedirectView rw = new RedirectView(DEFAULT_ERROR_VIEW, true);
        FlashMap outputFlashMap = RequestContextUtils.getOutputFlashMap((HttpServletRequest)request);
        if (outputFlashMap != null) {
            outputFlashMap.put((Object)"error", (Object)e.getMessage());
            outputFlashMap.put((Object)"url", (Object)request.getRequestURL());
        }
        return rw;
    }
}

