/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.properties.ApplicationProperties;
import org.springframework.beans.factory.annotation.Autowired;

public class ApplicationCoreFilter
implements Filter {
    @Autowired
    private CityService cityService;
    @Autowired
    private ApplicationProperties applicationProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpSession session = request.getSession();
        try {
            this.prepareCityPreferences(session);
            this.prepareThreadLocal(session);
            chain.doFilter((ServletRequest)request, resp);
        }
        finally {
            ApplicationThreadLocals.clearValues();
        }
    }

    private void prepareCityPreferences(HttpSession session) {
        if (session.getAttribute("cityCode") == null) {
            this.cityService.cityDataAsMap().forEach((k, v) -> session.setAttribute(k, v));
        }
    }

    private void prepareThreadLocal(HttpSession session) {
        ApplicationThreadLocals.setCityCode((String)session.getAttribute("cityCode"));
        ApplicationThreadLocals.setCityName((String)session.getAttribute("cityname"));
        ApplicationThreadLocals.setMunicipalityName((String)session.getAttribute("citymunicipalityname"));
        if (session.getAttribute("userid") != null) {
            ApplicationThreadLocals.setUserId((Long)session.getAttribute("userid"));
        }
        if (session.getServletContext().getAttribute("cdn") == null) {
            session.getServletContext().setAttribute("cdn", (Object)this.applicationProperties.getProperty("cdn.domain.url"));
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

