/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.validation;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="validatorUtils")
public class ValidatorUtils {
    private static Pattern PASSWORD_PATTERN;

    @Autowired
    public ValidatorUtils(ApplicationProperties applicationProperties) {
        String passwordStrength = applicationProperties.passwordStrength();
        PASSWORD_PATTERN = "high".equals(passwordStrength) ? Pattern.compile("(?=^.{8,32}$)(?=.*\\d)(?!.*[&<>#%\\'\\\"\\\\\\/])(?!.*\\s)(?=.*[A-Z])(?=.*[a-z]).*$") : ("medium".equals(passwordStrength) ? Pattern.compile("(?=^.{8,32}$)(?=.*\\d)(?!.*\\s)(?=.*[A-Z])(?=.*[a-z]).*$") : Pattern.compile("(?=^.{4,32}$)(?!.*\\s)(?=.*\\d)(?=.*[A-Z])(?=.*[a-z]).*$"));
    }

    public static void assertNotNull(Object value, String message) {
        if (value == null) {
            throw new ApplicationRuntimeException(message);
        }
    }

    public static void assertNotNull(String value, String message) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new ApplicationRuntimeException(message);
        }
    }

    public boolean isValidPassword(String pwd) {
        return StringUtils.isNotBlank((CharSequence)pwd) && PASSWORD_PATTERN.matcher(pwd).find();
    }
}

