/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.NumberToWord;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.Years;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    public static final String DFT_DATE_FORMAT = "dd/MM/yyyy";
    public static final DateTimeFormatter FORMAT_DATE_TO_YEAR = DateTimeFormat.forPattern((String)"yyyy");
    public static final DateTimeFormatter TO_DEFAULT_DATE_FORMAT = DateTimeFormat.forPattern((String)"dd/MM/yyyy");

    public static String currentDateToYearFormat() {
        return DateUtils.toYearFormat(new LocalDate());
    }

    public static String toYearFormat(LocalDate date) {
        return FORMAT_DATE_TO_YEAR.print((ReadablePartial)date);
    }

    public static String toYearFormat(java.util.Date date) {
        return FORMAT_DATE_TO_YEAR.print((ReadablePartial)new LocalDate((Object)date));
    }

    public static String currentDateToDefaultDateFormat() {
        return DateUtils.toDefaultDateFormat(new LocalDate());
    }

    public static String toDefaultDateFormat(LocalDate date) {
        return TO_DEFAULT_DATE_FORMAT.print((ReadablePartial)date);
    }

    public static java.util.Date endOfDay(java.util.Date date) {
        return new DateTime((Object)date).withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59).toDate();
    }

    public static DateTime endOfToday() {
        return new DateTime().withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59);
    }

    public static DateTime endOfGivenDate(DateTime dateTime) {
        return dateTime.withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59);
    }

    public static DateTime startOfGivenDate(DateTime dateTime) {
        return dateTime.withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0);
    }

    public static java.util.Date startOfDay(java.util.Date date) {
        return new DateTime((Object)date).withTimeAtStartOfDay().toDate();
    }

    public static java.util.Date[] getStartAndEndOfDay(java.util.Date startDate, java.util.Date endDate) {
        return new java.util.Date[]{DateUtils.startOfDay(startDate), DateUtils.endOfDay(endDate)};
    }

    public static int getNumberOfYearPassesed(java.util.Date startDate, java.util.Date endDate) {
        return new DateTime((Object)endDate).getYear() - new DateTime((Object)startDate).getYear();
    }

    public static int noOfMonths(java.util.Date startDate, java.util.Date endDate) {
        DateTime sDate = new DateTime((Object)startDate);
        DateTime eDate = new DateTime((Object)endDate);
        return Months.monthsBetween((ReadableInstant)sDate.withDayOfMonth(sDate.getDayOfMonth()), (ReadableInstant)eDate.withDayOfMonth(eDate.getDayOfMonth())).getMonths();
    }

    public static int noOfDays(java.util.Date startDate, java.util.Date endDate) {
        return (int)((endDate.getTime() - startDate.getTime()) / 86400000L);
    }

    public static int noOfYears(java.util.Date startDate, java.util.Date endDate) {
        DateTime sDate = new DateTime((Object)startDate);
        DateTime eDate = new DateTime((Object)endDate);
        Years years = Years.yearsBetween((ReadableInstant)sDate, (ReadableInstant)eDate);
        return years.getYears();
    }

    public static java.util.Date add(java.util.Date inputDate, int addType, int addAmount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(inputDate);
        calendar.add(addType, addAmount);
        return calendar.getTime();
    }

    public static boolean compareDates(java.util.Date firstDate, java.util.Date secondDate) {
        return firstDate == null || secondDate == null ? true : !firstDate.before(secondDate);
    }

    public static java.util.Date[] constructDateRange(java.util.Date fromDate, java.util.Date toDate) {
        java.util.Date[] dates = new java.util.Date[2];
        Calendar calfrom = Calendar.getInstance();
        calfrom.setTime(fromDate);
        calfrom.set(10, 0);
        calfrom.set(12, 0);
        calfrom.set(13, 0);
        calfrom.set(9, 0);
        dates[0] = calfrom.getTime();
        Calendar calto = Calendar.getInstance();
        calto.setTime(toDate);
        calto.set(10, 0);
        calto.set(12, 0);
        calto.set(13, 0);
        calto.add(5, 1);
        dates[1] = calto.getTime();
        return dates;
    }

    public static java.util.Date[] constructDateRange(String fromDate, String toDate) throws ParseException {
        return DateUtils.constructDateRange(DateUtils.getDateFormatter(DFT_DATE_FORMAT).parse(fromDate), DateUtils.getDateFormatter(DFT_DATE_FORMAT).parse(toDate));
    }

    public static java.util.Date createDate(int year) {
        Calendar date = Calendar.getInstance();
        date.set(1, year);
        date.set(2, 0);
        date.set(5, 1);
        return date.getTime();
    }

    public static Map<Integer, String> getAllMonths() {
        HashMap<Integer, String> monthMap = new HashMap<Integer, String>();
        monthMap.put(1, "Jan");
        monthMap.put(2, "Feb");
        monthMap.put(3, "Mar");
        monthMap.put(4, "Apr");
        monthMap.put(5, "May");
        monthMap.put(6, "Jun");
        monthMap.put(7, "July");
        monthMap.put(8, "Aug");
        monthMap.put(9, "Sep");
        monthMap.put(10, "Oct");
        monthMap.put(11, "Nov");
        monthMap.put(12, "Dec");
        return monthMap;
    }

    public static Map<Integer, String> getAllMonthsWithFullNames() {
        HashMap<Integer, String> monthMap = new HashMap<Integer, String>();
        monthMap.put(1, "January");
        monthMap.put(2, "Feburary");
        monthMap.put(3, "March");
        monthMap.put(4, "April");
        monthMap.put(5, "May");
        monthMap.put(6, "June");
        monthMap.put(7, "July");
        monthMap.put(8, "August");
        monthMap.put(9, "September");
        monthMap.put(10, "October");
        monthMap.put(11, "November");
        monthMap.put(12, "December");
        return monthMap;
    }

    public static java.util.Date getDate(String date, String pattern) {
        try {
            return StringUtils.isNotBlank((String)date) && StringUtils.isNotBlank((String)pattern) ? DateUtils.getDateFormatter(pattern).parse(date) : null;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Date or Pattern value is not valid", e);
        }
    }

    public static java.util.Date getDate(int year, int month, int date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, date);
        return calendar.getTime();
    }

    public static String getDefaultFormattedDate(java.util.Date date) {
        return DateUtils.getDateFormatter(DFT_DATE_FORMAT).format(date);
    }

    private static int getSecondYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int currenty = calendar.get(1);
        int Year2 = 0;
        int currentm = calendar.get(2);
        int lstmonth = 3;
        Year2 = currentm >= 3 ? currenty + 1 : currenty - 1;
        return Year2;
    }

    public static String getFormattedDate(java.util.Date date, String pattern) {
        return DateUtils.getDateFormatter(pattern).format(date);
    }

    public static java.util.Date now() {
        return new java.util.Date();
    }

    public static java.util.Date today() {
        Calendar calendar = Calendar.getInstance();
        return DateUtils.getDate(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    public static java.util.Date tomorrow() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public static String convertToWords(java.util.Date dateToConvert) {
        String[] DATE_WORD = new String[]{"First", "Second", "Third", "Fourth", "Fifth", "Sixth", "Seventh", "Eighth", "Ninth", "Tenth", "Eleventh", "Twelfth", "Thirteenth", "Fourteenth", "Fifteenth", "Sixteenth", "Seventeenth", "Eighteenth", "Nineteenth", "Twentieth", "Twenty first", "Twenty second", "Twenty third", "Twenty fourth", "Twenty fifth", "Twenty sixth", "Twenty seventh", "Twenty eighth", "Twenty ninth", "Thirtieth", "Thirty first"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateToConvert);
        StringBuilder dateInWord = new StringBuilder();
        dateInWord.append(DATE_WORD[cal.get(5) - 1]).append(" ");
        dateInWord.append(DateUtils.getDateFormatter("dd-MMMMM-yyyy").format(dateToConvert).split("-")[1]).append(" ");
        dateInWord.append(NumberToWord.translateToWord(String.valueOf(cal.get(1))));
        return dateInWord.toString();
    }

    public static SimpleDateFormat getDateFormatter(String pattern) {
        return new SimpleDateFormat(pattern, Locale.getDefault());
    }

    public static boolean between(java.util.Date date, java.util.Date fromDate, java.util.Date toDate) {
        return (date.after(fromDate) || date.equals(fromDate)) && date.before(toDate) || date.equals(toDate);
    }

    public static Map<Integer, String> getAllFinancialYearMonthsWithFullNames() {
        HashMap<Integer, String> monthMap = new HashMap<Integer, String>();
        monthMap.put(1, "April");
        monthMap.put(2, "May");
        monthMap.put(3, "June");
        monthMap.put(4, "July");
        monthMap.put(5, "August");
        monthMap.put(6, "September");
        monthMap.put(7, "October");
        monthMap.put(8, "November");
        monthMap.put(9, "December");
        monthMap.put(10, "January");
        monthMap.put(11, "Feburary");
        monthMap.put(12, "March");
        return monthMap;
    }
}

