/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.persistence.validator;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class UniqueCheckValidator
implements ConstraintValidator<Unique, Object> {
    private Unique unique;
    @PersistenceContext
    private EntityManager entityManager;

    public void initialize(Unique unique) {
        this.unique = unique;
    }

    public boolean isValid(Object arg0, ConstraintValidatorContext constraintValidatorContext) {
        try {
            Number id = (Number)FieldUtils.readField((Object)arg0, (String)this.unique.id(), (boolean)true);
            boolean isValid = true;
            for (String fieldName : this.unique.fields()) {
                if (this.checkUnique(arg0, id, fieldName)) continue;
                isValid = false;
                if (!this.unique.enableDfltMsg()) continue;
                constraintValidatorContext.buildConstraintViolationWithTemplate(this.unique.message()).addPropertyNode(fieldName).addConstraintViolation();
            }
            return isValid;
        }
        catch (IllegalAccessException e) {
            throw new ApplicationRuntimeException("Error while validating unique key", e);
        }
    }

    private boolean checkUnique(Object arg0, Number id, String fieldName) throws IllegalAccessException {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(this.unique.isSuperclass() ? arg0.getClass().getSuperclass() : arg0.getClass());
        Object fieldValue = FieldUtils.readField((Object)arg0, (String)fieldName, (boolean)true);
        if (fieldValue instanceof String) {
            criteria.add((Criterion)Restrictions.eq((String)fieldName, (Object)fieldValue).ignoreCase());
        } else {
            criteria.add((Criterion)Restrictions.eq((String)fieldName, (Object)fieldValue));
        }
        if (id != null) {
            criteria.add((Criterion)Restrictions.ne((String)this.unique.id(), (Object)id));
        }
        return criteria.setProjection((Projection)Projections.id()).setMaxResults(1).uniqueResult() == null;
    }
}

