/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.persistence.utils;

import java.io.Serializable;
import java.sql.SQLException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApplicationSequenceNumberGenerator {
    public static String WORD_SEPARATOR_FOR_NAME = "_";
    private static final String DISALLOWED_CHARACTERS = "[\\/ -]";
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;

    @Transactional
    public Serializable getNextSequence(String sequenceName) {
        Serializable sequenceNumber;
        sequenceName = sequenceName.replaceAll(DISALLOWED_CHARACTERS, WORD_SEPARATOR_FOR_NAME);
        try {
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(sequenceName);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(sequenceName);
            }
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while getting next value for sequence : " + sequenceName, e);
        }
        return sequenceNumber;
    }
}

