/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.persistence.entity;

import com.google.gson.annotations.Expose;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.egov.infra.persistence.entity.enums.AddressType;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="eg_address")
@Inheritance(strategy=InheritanceType.JOINED)
@SequenceGenerator(name="seq_eg_address", sequenceName="seq_eg_address", allocationSize=1)
@Cacheable
public abstract class Address
extends AbstractPersistable<Long> {
    public static final String SEQ_ADDRESS = "seq_eg_address";
    private static final long serialVersionUID = 4842889134725565148L;
    @Expose
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_eg_address")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="userid")
    private User user;
    @SafeHtml
    private String houseNoBldgApt;
    @SafeHtml
    private String streetRoadLine;
    @SafeHtml
    private String landmark;
    @SafeHtml
    private String areaLocalitySector;
    @SafeHtml
    private String cityTownVillage;
    @SafeHtml
    private String district;
    @SafeHtml
    private String subdistrict;
    @SafeHtml
    private String postOffice;
    @SafeHtml
    private String state;
    @SafeHtml
    private String country;
    @SafeHtml
    private String pinCode;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type")
    private AddressType type;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getHouseNoBldgApt() {
        return this.houseNoBldgApt;
    }

    public void setHouseNoBldgApt(String houseNoBldgApt) {
        this.houseNoBldgApt = houseNoBldgApt;
    }

    public String getStreetRoadLine() {
        return this.streetRoadLine;
    }

    public void setStreetRoadLine(String streetRoadLine) {
        this.streetRoadLine = streetRoadLine;
    }

    public String getLandmark() {
        return this.landmark;
    }

    public void setLandmark(String landmark) {
        this.landmark = landmark;
    }

    public String getAreaLocalitySector() {
        return this.areaLocalitySector;
    }

    public void setAreaLocalitySector(String areaLocalitySector) {
        this.areaLocalitySector = areaLocalitySector;
    }

    public String getCityTownVillage() {
        return this.cityTownVillage;
    }

    public void setCityTownVillage(String cityTownVillage) {
        this.cityTownVillage = cityTownVillage;
    }

    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getSubdistrict() {
        return this.subdistrict;
    }

    public void setSubdistrict(String subdistrict) {
        this.subdistrict = subdistrict;
    }

    public String getPostOffice() {
        return this.postOffice;
    }

    public void setPostOffice(String postOffice) {
        this.postOffice = postOffice;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getPinCode() {
        return this.pinCode;
    }

    public void setPinCode(String pinCode) {
        this.pinCode = pinCode;
    }

    public AddressType getType() {
        return this.type;
    }

    public void setType(AddressType type) {
        this.type = type;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Address other = (Address)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.houseNoBldgApt)) {
            builder.append(StringUtils.trim((String)this.houseNoBldgApt)).append(", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.areaLocalitySector)) {
            builder.append(StringUtils.trim((String)this.areaLocalitySector)).append(", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.streetRoadLine)) {
            builder.append(StringUtils.trim((String)this.streetRoadLine)).append(", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.landmark)) {
            builder.append(StringUtils.trim((String)this.landmark)).append(", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.cityTownVillage)) {
            builder.append(StringUtils.trim((String)this.cityTownVillage)).append(", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.postOffice)) {
            builder.append(StringUtils.trim((String)this.postOffice)).append(", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.subdistrict)) {
            builder.append(StringUtils.trim((String)this.subdistrict)).append(", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.district)) {
            builder.append(StringUtils.trim((String)this.district)).append(", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.state)) {
            builder.append(StringUtils.trim((String)this.state)).append(", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.country)) {
            builder.append(StringUtils.trim((String)this.country)).append(", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.pinCode)) {
            builder.append("PIN : ").append(this.pinCode);
        }
        return builder.toString();
    }
}

