/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.properties.messages;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.infra.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@Configuration
public class MessageSourceProperties {
    private static final Logger LOG = LoggerFactory.getLogger(MessageSourceProperties.class);
    @Autowired
    private ApplicationProperties applicationConfigProperties;
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    @Bean
    public ReloadableResourceBundleMessageSource parentMessageSource() {
        ReloadableResourceBundleMessageSource resource = new ReloadableResourceBundleMessageSource();
        resource.setBasenames(this.processResourceWithPattern(this.applicationConfigProperties.commonMessageFiles()));
        resource.setDefaultEncoding(Charset.defaultCharset().name());
        if (this.applicationConfigProperties.devMode()) {
            resource.setCacheSeconds(0);
            resource.setUseCodeAsDefaultMessage(true);
        }
        return resource;
    }

    private String[] processResourceWithPattern(String ... baseNames) {
        ArrayList<String> resources = new ArrayList<String>();
        for (String baseName : baseNames) {
            if (baseName.contains("*")) {
                try {
                    Resource[] relResources;
                    for (Resource relResource : relResources = this.resourcePatternResolver.getResources("classpath*:" + baseName)) {
                        resources.add("messages/" + relResource.getFilename().replace(".properties", ""));
                    }
                    continue;
                }
                catch (IOException e) {
                    LOG.warn("Could not load property file : {}", (Object)baseName);
                    continue;
                }
            }
            resources.add(baseName);
        }
        return StringUtils.listToStringArray(resources);
    }
}

