/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.Date;
import java.util.List;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.repository.AppConfigValueRepository;
import org.egov.infra.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AppConfigValueService {
    private final AppConfigValueRepository appConfigValueRepository;

    @Autowired
    public AppConfigValueService(AppConfigValueRepository appConfigValueRepos) {
        this.appConfigValueRepository = appConfigValueRepos;
    }

    public List<AppConfigValues> getConfigValuesByModuleAndKey(String moduleName, String keyName) {
        return this.appConfigValueRepository.findByConfig_KeyNameAndConfig_Module_Name(keyName, moduleName);
    }

    public List<AppConfigValues> getConfigValuesByModuleAndKeyLike(String moduleName, String keyName) {
        return this.appConfigValueRepository.findByConfig_KeyNameLikeAndConfig_Module_Name(keyName, moduleName);
    }

    public List<AppConfigValues> getConfigValuesByModuleAndKeyByValueAsc(String moduleName, String keyName) {
        return this.appConfigValueRepository.findByConfig_KeyNameAndConfig_Module_NameOrderByValueAsc(keyName, moduleName);
    }

    public AppConfigValues getAppConfigValueByDate(String moduleName, String keyName, Date effectiveFrom) {
        Date toDate;
        Date[] dateRange = DateUtils.constructDateRange(effectiveFrom, effectiveFrom);
        Date fromDate = dateRange[0];
        List<AppConfigValues> appConfigValues = this.appConfigValueRepository.getAppConfigValueByModuleAndKeyAndDate(moduleName, keyName, effectiveFrom, fromDate, toDate = dateRange[1]);
        return appConfigValues.isEmpty() ? null : appConfigValues.get(appConfigValues.size() - 1);
    }

    public String getAppConfigValue(String moduleName, String keyName, String defaultVal) {
        Date toDate;
        Date effectiveFrom = new Date();
        Date[] dateRange = DateUtils.constructDateRange(effectiveFrom, effectiveFrom);
        Date fromDate = dateRange[0];
        List<AppConfigValues> appConfigValues = this.appConfigValueRepository.getAppConfigValueByModuleAndKeyAndDate(moduleName, keyName, effectiveFrom, fromDate, toDate = dateRange[1]);
        return appConfigValues.isEmpty() ? defaultVal : appConfigValues.get(appConfigValues.size() - 1).toString();
    }
}

