/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.matrix.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CustomizedWorkFlowService {
    private static final String DESGQUERY = "getDesignationForListOfDesgNames";
    @Autowired
    @Qualifier(value="entityQueryService")
    private PersistenceService entityQueryService;
    @Autowired
    @Qualifier(value="workflowService")
    private WorkflowService<? extends StateAware> workflowService;

    public List<Designation> getNextDesignations(String type, String department, BigDecimal businessRule, String additionalRule, String currentState, String pendingAction, Date date) {
        WorkFlowMatrix wfMatrix = this.workflowService.getWfMatrix(type, department, businessRule, additionalRule, currentState, pendingAction, date);
        ArrayList<String> designationNames = new ArrayList<String>();
        if (wfMatrix != null && wfMatrix.getNextDesignation() != null) {
            List<String> tempDesignationName = Arrays.asList(wfMatrix.getNextDesignation().split(","));
            for (String desgName : tempDesignationName) {
                if (desgName == null || "".equals(desgName.trim())) continue;
                designationNames.add(desgName.toUpperCase());
            }
        }
        List designationList = Collections.EMPTY_LIST;
        if (!designationNames.isEmpty()) {
            designationList = this.entityQueryService.findAllByNamedQuery(DESGQUERY, designationNames);
        }
        return designationList;
    }

    public List<String> getNextValidActions(String type, String departmentName, BigDecimal businessRule, String additionalRule, String currentState, String pendingAction) {
        WorkFlowMatrix wfMatrix = this.workflowService.getWfMatrix(type, departmentName, businessRule, additionalRule, currentState, pendingAction);
        List<String> validActions = Collections.EMPTY_LIST;
        if (wfMatrix != null && wfMatrix.getValidActions() != null) {
            validActions = Arrays.asList(wfMatrix.getValidActions().split(","));
        }
        return validActions;
    }

    public List<String> getNextValidActions(String type, String departmentName, BigDecimal businessRule, String additionalRule, String currentState, String pendingAction, Date date) {
        WorkFlowMatrix wfMatrix = this.workflowService.getWfMatrix(type, departmentName, businessRule, additionalRule, currentState, pendingAction, date);
        List<String> validActions = Collections.EMPTY_LIST;
        if (wfMatrix != null && wfMatrix.getValidActions() != null) {
            validActions = Arrays.asList(wfMatrix.getValidActions().split(","));
        }
        return validActions;
    }

    public WorkFlowMatrix getWfMatrix(String type, String department, BigDecimal businessRule, String additionalRule, String currentState, String pendingAction, Date date) {
        return this.workflowService.getWfMatrix(type, department, businessRule, additionalRule, currentState, pendingAction, date);
    }

    public WorkFlowMatrix getWfMatrix(String type, String department, BigDecimal businessRule, String additionalRule, String currentState, String pendingAction) {
        return this.workflowService.getWfMatrix(type, department, businessRule, additionalRule, currentState, pendingAction);
    }
}

