/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.struts.actions;

import java.util.HashMap;
import java.util.Map;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ReportFormAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> reportParams = new HashMap<String, Object>();
    private ReportService reportService;
    private String reportId;
    public static final String REPORT = "report";
    private ReportConstants.FileFormat reportFormat = ReportConstants.FileFormat.PDF;
    private ReportRequest.ReportDataSourceType dataSourceType = ReportRequest.ReportDataSourceType.SQL;
    private Object reportData = null;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public Object getModel() {
        return null;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    protected void clearCriteriaParams() {
        this.reportParams.clear();
    }

    public void setReportParam(String paramName, Object paramValue) {
        this.reportParams.put(paramName, paramValue);
    }

    protected Object getReportParam(String paramName) {
        return this.reportParams.get(paramName);
    }

    public void setReportFormat(ReportConstants.FileFormat reportFormat) {
        this.reportFormat = reportFormat;
    }

    public ReportConstants.FileFormat getReportFormat() {
        return this.reportFormat;
    }

    public void setDataSourceType(ReportRequest.ReportDataSourceType dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public ReportRequest.ReportDataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    public void setReportData(Object reportData) {
        this.reportData = reportData;
    }

    public Object getReportData() {
        return this.reportData;
    }

    public String getReportId() {
        return this.reportId;
    }

    public String report() {
        ReportRequest reportInput = null;
        String reportTemplateName = this.getReportTemplateName();
        if (this.dataSourceType == ReportRequest.ReportDataSourceType.JAVABEAN) {
            if (this.reportData == null) {
                throw new ApplicationRuntimeException("Report Data not set!");
            }
            reportInput = new ReportRequest(reportTemplateName, this.reportData, this.reportParams);
        } else {
            reportInput = new ReportRequest(reportTemplateName, this.reportParams, this.dataSourceType);
        }
        reportInput.setReportFormat(this.reportFormat);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        return REPORT;
    }

    public abstract String criteria();

    protected abstract String getReportTemplateName();
}

