/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.web.utils.WebUtils;
import org.slf4j.MDC;

public class MDCLoggingFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            MDC.put((String)"ulbcode", (String)ApplicationThreadLocals.getCityName());
            MDC.put((String)"appname", (String)WebUtils.currentContextPath(request));
            chain.doFilter(request, response);
        }
        finally {
            MDC.clear();
        }
    }

    public void destroy() {
    }
}

