/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.displaytag.export;

import java.io.StringReader;
import org.apache.commons.lang.StringUtils;
import org.displaytag.export.BaseExportView;
import org.displaytag.model.TableModel;
import org.egov.infra.web.displaytag.export.MyHtmlParser;

public class EGovExcelView
extends BaseExportView {
    public void setParameters(TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        super.setParameters(tableModel, exportFullList, includeHeader, decorateValues);
    }

    public String getMimeType() {
        return "application/vnd.ms-excel";
    }

    protected String getRowEnd() {
        return "\n";
    }

    protected String getCellEnd() {
        return "\t";
    }

    protected String getDocumentStart() {
        return this.escapeColumnValue(super.getDocumentStart());
    }

    protected boolean getAlwaysAppendCellEnd() {
        return false;
    }

    protected boolean getAlwaysAppendRowEnd() {
        return false;
    }

    protected String escapeColumnValue(Object value) {
        if (value != null && !value.toString().trim().equalsIgnoreCase("")) {
            value = this.removeHtmlTagsAndSpaces(value.toString());
            return "\"" + StringUtils.replace((String)StringUtils.trim((String)value.toString()), (String)"\"", (String)"\"\"") + "\"";
        }
        return null;
    }

    private String removeHtmlTagsAndSpaces(String strValue) {
        String returnValue = null;
        if (strValue != null) {
            StringReader strReader = new StringReader(strValue);
            MyHtmlParser parser = new MyHtmlParser();
            returnValue = parser.parseMyHtml(strReader, true);
        }
        return returnValue;
    }
}

