/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils.autonumber;

import java.util.Map;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.autonumber.OverrideImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class AutonumberServiceBeanResolver {
    @Autowired
    private ApplicationContext context;

    public <T> T getAutoNumberServiceFor(Class<T> autoNumberInterface) {
        Map autoNumberImpls = this.context.getBeansOfType(autoNumberInterface);
        if (autoNumberImpls.isEmpty()) {
            throw new ApplicationRuntimeException("Could not find any implementation bean for interface " + autoNumberInterface.getSimpleName());
        }
        if (autoNumberImpls.size() > 1) {
            for (Object autoNumberImpl : autoNumberImpls.values()) {
                if (!autoNumberImpl.getClass().isAnnotationPresent(OverrideImpl.class)) continue;
                return (T)autoNumberImpl;
            }
        }
        return (T)autoNumberImpls.values().iterator().next();
    }
}

