/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class ImageUtils {
    public static final String JPG_EXTN = ".jpg";

    public static InputStream compressImage(InputStream imgInStream) throws IOException {
        return ImageUtils.compressImage(imgInStream, "compressed_file");
    }

    public static InputStream compressImage(InputStream imgInStream, String compressedImgFileName) throws IOException {
        File compressedImageFile = new File(compressedImgFileName + JPG_EXTN);
        try (ImageOutputStream ios = ImageIO.createImageOutputStream(compressedImageFile);){
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = writers.next();
            writer.setOutput(ios);
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(1);
            writer.write(null, new IIOImage(ImageIO.read(imgInStream), null, null), param);
            imgInStream.close();
            writer.dispose();
        }
        return new FileInputStream(compressedImageFile);
    }
}

