/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.repository.FileStoreMapperRepository;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.ImageUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileStoreUtils {
    @Qualifier(value="localDiskFileStoreService")
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private FileStoreMapperRepository fileStoreMapperRepository;

    public void fetchFileAndWriteToStream(String fileStoreId, String moduleName, boolean toSave, HttpServletResponse response) throws IOException {
        FileStoreMapper fileStoreMapper = this.fileStoreMapperRepository.findByFileStoreId(fileStoreId);
        if (fileStoreMapper != null) {
            File file = this.fileStoreService.fetch(fileStoreMapper, moduleName);
            if (toSave) {
                response.setHeader("Content-Disposition", "attachment;filename=" + fileStoreMapper.getFileName());
            } else {
                response.setHeader("Content-Disposition", "inline;filename=" + fileStoreMapper.getFileName());
            }
            response.setContentType(fileStoreMapper.getContentType());
            ServletOutputStream out = response.getOutputStream();
            IOUtils.write((byte[])FileUtils.readFileToByteArray((File)file), (OutputStream)out);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public Set<FileStoreMapper> addToFileStore(MultipartFile[] files, String moduleName) {
        return this.addToFileStore(files, moduleName, false);
    }

    public Set<FileStoreMapper> addToFileStore(MultipartFile[] files, String moduleName, boolean compressImage) {
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            return Arrays.asList(files).stream().filter(file -> !file.isEmpty()).map(file -> {
                try {
                    if (compressImage && file.getContentType().contains("image")) {
                        return this.fileStoreService.store(ImageUtils.compressImage(file.getInputStream()), file.getOriginalFilename(), "image/jpeg", moduleName);
                    }
                    return this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), moduleName);
                }
                catch (Exception e) {
                    throw new ApplicationRuntimeException("err.input.stream", e);
                }
            }).collect(Collectors.toSet());
        }
        return null;
    }

    public void copyFileToPath(Path newFilePath, String fileStoreId, String moduleName) throws IOException {
        FileStoreMapper fileStoreMapper = this.fileStoreMapperRepository.findByFileStoreId(fileStoreId);
        if (fileStoreMapper != null) {
            File file = this.fileStoreService.fetch(fileStoreMapper, moduleName);
            Files.copy(file.toPath(), newFilePath, new CopyOption[0]);
        }
    }
}

