/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.security.utils;

import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VirtualSanitizer {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualSanitizer.class);
    private static Policy policy;
    private static AntiSamy antiSamy;

    private static AntiSamy getAntiSamy() throws PolicyException {
        if (antiSamy == null) {
            policy = VirtualSanitizer.getPolicy("antisamy-myspace-1.4.3.xml");
            antiSamy = new AntiSamy();
        }
        return antiSamy;
    }

    private static Policy getPolicy(String name) throws PolicyException {
        Policy policy = Policy.getInstance((URL)VirtualSanitizer.class.getResource(name));
        return policy;
    }

    public static String sanitize(String input) {
        try {
            if (StringUtils.isBlank((String)input)) {
                return input;
            }
            CleanResults cr = VirtualSanitizer.getAntiSamy().scan(input, policy);
            if (cr.getErrorMessages().size() > 0) {
                LOG.error(cr.getErrorMessages().toString());
                throw new ApplicationRuntimeException("Found security threat in user input : " + cr.getErrorMessages());
            }
            return input;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            throw new ApplicationRuntimeException("Error occurred while validating inputs", e);
        }
    }
}

