/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.security.token.service;

import java.util.Date;
import org.egov.infra.security.token.entity.Token;
import org.egov.infra.security.token.repository.TokenRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TokenService {
    private static final long DEFAULT_ALLOWED_TOKEN_AGE_SECS = 300L;
    private final TokenRepository tokenRepository;

    @Autowired
    public TokenService(TokenRepository tokenRepository) {
        this.tokenRepository = tokenRepository;
    }

    public Token getToken(String tokenNumber, String tokenIdentity, String service) {
        return this.tokenRepository.findByTokenNumberAndTokenIdentityAndService(tokenNumber, tokenIdentity, service);
    }

    @Transactional
    public Token generate(String tokenNumber, String tokenIdentity, String service) {
        return this.createToken(300L, tokenNumber, tokenIdentity, service);
    }

    @Transactional
    public Token createToken(long ttlSecs, String tokenNumber, String tokenIdentity, String service) {
        Token token = new Token();
        token.setTokenNumber(tokenNumber);
        token.setTtlSecs(ttlSecs);
        token.setCreatedDate(new Date());
        token.setService(service);
        token.setTokenIdentity(tokenIdentity);
        return (Token)this.tokenRepository.save(token);
    }

    @Transactional
    public boolean redeemToken(String tokenNumber, String tokenIdentity, String service) {
        Token token = this.getToken(tokenNumber, tokenIdentity, service);
        if (token != null) {
            this.tokenRepository.delete(token);
        }
        return token != null && token.isRedeemable();
    }
}

