/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.search.elastic.service;

import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.search.elastic.annotation.Indexing;
import org.egov.infra.search.elastic.entity.ApplicationIndex;
import org.egov.infra.search.elastic.repository.ApplicationIndexRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ApplicationIndexService {
    private final ApplicationIndexRepository applicationIndexRepository;
    @Autowired
    private CityService cityService;

    @Autowired
    public ApplicationIndexService(ApplicationIndexRepository applicationIndexRepository) {
        this.applicationIndexRepository = applicationIndexRepository;
    }

    @Transactional
    @Indexing(name=Index.APPLICATION, type=IndexType.APPLICATIONSEARCH)
    public ApplicationIndex createApplicationIndex(ApplicationIndex applicationIndex) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        applicationIndex.setCityCode(cityWebsite.getCode() != null ? cityWebsite.getCode() : "");
        applicationIndex.setCityName(cityWebsite.getName() != null ? cityWebsite.getName() : "");
        applicationIndex.setCityGrade(cityWebsite.getGrade() != null ? cityWebsite.getGrade() : "");
        applicationIndex.setDistrictName(cityWebsite.getDistrictName() != null ? cityWebsite.getDistrictName() : "");
        applicationIndex.setRegionName(cityWebsite.getRegionName() != null ? cityWebsite.getRegionName() : "");
        this.applicationIndexRepository.save(applicationIndex);
        return applicationIndex;
    }

    @Transactional
    @Indexing(name=Index.APPLICATION, type=IndexType.APPLICATIONSEARCH)
    public ApplicationIndex updateApplicationIndex(ApplicationIndex applicationIndex) {
        this.applicationIndexRepository.save(applicationIndex);
        return applicationIndex;
    }

    public ApplicationIndex findByApplicationNumber(String applicationNumber) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        return this.applicationIndexRepository.findByApplicationNumberAndCityName(applicationNumber, cityWebsite.getName());
    }
}

