/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.persistence.utils;

import java.io.Serializable;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DBSequenceGenerator {
    public static final String NEXT_SEQ_SQL_QUERY = "SELECT nextval (:sequenceName) as nextval";
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW, noRollbackFor={SQLGrammarException.class})
    public Serializable createAndGetNextSequence(String sequenceName) throws SQLException {
        SQLQuery query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery("create sequence " + sequenceName);
        query.executeUpdate();
        query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(NEXT_SEQ_SQL_QUERY);
        query.setParameter("sequenceName", (Object)sequenceName);
        return (Serializable)query.uniqueResult();
    }
}

