/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.properties;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration
@PropertySource(value={"classpath:config/application-config.properties", "classpath:config/egov-erp-${user.name}.properties", "classpath:config/application-config-${client.id}.properties", "classpath:config/egov-erp-override.properties"}, ignoreResourceNotFound=true)
@Order(value=0)
public class ApplicationProperties {
    public static final String FILESTORE_BASE_DIR = "filestore.base.dir";
    public static final String FILESTORESERVICE_BEANNAME = "filestoreservice.beanname";
    public static final String DEFAULT_DATE_PATTERN = "default.date.pattern";
    public static final String MAIL_PORT = "mail.port";
    public static final String MAIL_HOST = "mail.host";
    public static final String MAIL_PROTOCOL = "mail.protocol";
    public static final String MAIL_SENDER_USERNAME = "mail.sender.username";
    public static final String MAIL_SENDER_PASWRD = "mail.sender.password";
    public static final String MAIL_SMTPS_AUTH = "mail.smtps.auth";
    public static final String MAIL_SMTPS_STARTTLS_ENABLE = "mail.smtps.starttls.enable";
    public static final String MAIL_SMTPS_DEBUG = "mail.smtps.debug";
    public static final String SMS_PROVIDER_URL = "sms.provider.url";
    public static final String SMS_SENDER_USERNAME = "sms.sender.username";
    public static final String SMS_SENDER_PASWRD = "sms.sender.password";
    public static final String SMS_SENDER = "sms.sender";
    public static final String COMMON_PROPERTIES_FILES = "common.properties.files";
    public static final String DEV_MODE = "dev.mode";
    public static final String MAIL_ENABLED = "mail.enabled";
    public static final String SMS_ENABLED = "sms.enabled";
    public static final String USER_PASWRD_EXPIRY_DAYS = "user.pwd.expiry.days";
    public static final String SMS_ERROR_CODES = "sms.error.codes";
    public static final String MULTITENANCY_ENABLED = "multitenancy.enabled";
    public static final String APP_VERSION = "app.version";
    public static final String APP_BUILD_NO = "app.build.no";
    public static final String APP_CORE_BUILD_NO = "app.core.build.no";
    public static final String ISSUE_REPORT_URL = "issue.report.url";
    public static final String PORTAL_FEATURE_ENABLED = "portal.feature.enabled";
    public static final String STATEWIDE_MIGRATION_REQUIRED = "statewide.migration.required";
    public static final String HIBERNATE_JDBC_BATCH_SIZE = "hibernate.jdbc.batch_size";
    public static final String USER_PASWRD_STRENGTH = "user.pwd.strength";
    public static final String REDIS_ENABLE_SENTINEL = "redis.enable.sentinel";
    public static final String REDIS_SENTINEL_HOSTS = "redis.sentinel.hosts";
    public static final String REDIS_SENTINEL_MASTER_NAME = "redis.sentinel.master.name";
    public static final String REDIS_ENABLE_EMBEDDED = "redis.enable.embedded";
    public static final String REDIS_HOST_NAME = "redis.host.name";
    public static final String REDIS_HOST_PORT = "redis.host.port";
    public static final String MASTER_SERVER = "master.server";
    public static final String FLYWAY_VALIDATEON_MIGRATE = "flyway.validateon.migrate";
    @Autowired
    private Environment environment;

    public String fileStoreBaseDir() {
        return this.environment.getProperty(FILESTORE_BASE_DIR);
    }

    public String filestoreServiceBeanName() {
        return this.environment.getProperty(FILESTORESERVICE_BEANNAME);
    }

    public String defaultDatePattern() {
        return this.environment.getProperty(DEFAULT_DATE_PATTERN);
    }

    public Integer mailPort() {
        return (Integer)this.environment.getProperty(MAIL_PORT, Integer.class);
    }

    public String mailHost() {
        return this.environment.getProperty(MAIL_HOST);
    }

    public String mailProtocol() {
        return this.environment.getProperty(MAIL_PROTOCOL);
    }

    public String mailSenderUsername() {
        return this.environment.getProperty(MAIL_SENDER_USERNAME);
    }

    public String mailSenderPassword() {
        return this.environment.getProperty(MAIL_SENDER_PASWRD);
    }

    public String mailSMTPSAuth() {
        return this.environment.getProperty(MAIL_SMTPS_AUTH);
    }

    public String mailStartTLSEnabled() {
        return this.environment.getProperty(MAIL_SMTPS_STARTTLS_ENABLE);
    }

    public String mailSMTPSDebug() {
        return this.environment.getProperty(MAIL_SMTPS_DEBUG);
    }

    public String smsProviderURL() {
        return this.environment.getProperty(SMS_PROVIDER_URL);
    }

    public String smsSenderUsername() {
        return this.environment.getProperty(SMS_SENDER_USERNAME);
    }

    public String smsSenderPassword() {
        return this.environment.getProperty(SMS_SENDER_PASWRD);
    }

    public String smsSender() {
        return this.environment.getProperty(SMS_SENDER);
    }

    public String[] commonMessageFiles() {
        return this.environment.getProperty(COMMON_PROPERTIES_FILES).split(",");
    }

    public boolean devMode() {
        return (Boolean)this.environment.getProperty(DEV_MODE, Boolean.class);
    }

    public boolean emailEnabled() {
        return (Boolean)this.environment.getProperty(MAIL_ENABLED, Boolean.class);
    }

    public boolean smsEnabled() {
        return (Boolean)this.environment.getProperty(SMS_ENABLED, Boolean.class);
    }

    public Integer userPasswordExpiryInDays() {
        return (Integer)this.environment.getProperty(USER_PASWRD_EXPIRY_DAYS, Integer.class);
    }

    public List<String> smsErrorCodes() {
        return Arrays.asList(this.environment.getProperty(SMS_ERROR_CODES).split(","));
    }

    public String smsResponseMessageForCode(String errorCode) {
        return this.environment.getProperty(errorCode, "No Message");
    }

    public boolean multiTenancyEnabled() {
        return (Boolean)this.environment.getProperty(MULTITENANCY_ENABLED, Boolean.class);
    }

    public String getProperty(String propKey) {
        return this.environment.getProperty(propKey, "");
    }

    public <T> T getProperty(String propKey, Class<T> type) {
        return (T)this.environment.getProperty(propKey, type);
    }

    public String appVersion() {
        return this.environment.getProperty(APP_VERSION, "");
    }

    public String appBuildNo() {
        return this.environment.getProperty(APP_BUILD_NO, "");
    }

    public String appCoreBuildNo() {
        return this.environment.getProperty(APP_CORE_BUILD_NO, "");
    }

    public String issueReportingUrl() {
        return this.environment.getProperty(ISSUE_REPORT_URL, "");
    }

    public List<String> portalEnabledFeatures() {
        return Arrays.asList(this.environment.getProperty(PORTAL_FEATURE_ENABLED).split(","));
    }

    public boolean statewideMigrationRequired() {
        return (Boolean)this.environment.getProperty(STATEWIDE_MIGRATION_REQUIRED, Boolean.class, (Object)Boolean.FALSE);
    }

    public Integer getBatchUpdateSize() {
        return (Integer)this.environment.getProperty(HIBERNATE_JDBC_BATCH_SIZE, Integer.class);
    }

    public String passwordStrength() {
        return this.environment.getProperty(USER_PASWRD_STRENGTH);
    }

    public boolean sentinelEnabled() {
        return (Boolean)this.environment.getProperty(REDIS_ENABLE_SENTINEL, Boolean.class);
    }

    public List<String> sentinelHosts() {
        return Arrays.asList(this.environment.getProperty(REDIS_SENTINEL_HOSTS).split(","));
    }

    public String sentinelMasterName() {
        return this.environment.getProperty(REDIS_SENTINEL_MASTER_NAME);
    }

    public boolean usingEmbeddedRedis() {
        return (Boolean)this.environment.getProperty(REDIS_ENABLE_EMBEDDED, Boolean.class);
    }

    public String redisHost() {
        return this.environment.getProperty(REDIS_HOST_NAME);
    }

    public int redisPort() {
        return (Integer)this.environment.getProperty(REDIS_HOST_PORT, Integer.class);
    }

    public boolean isMasterServer() {
        return (Boolean)this.environment.getProperty(MASTER_SERVER, Boolean.class);
    }

    public boolean flywayValidateonMigrate() {
        return (Boolean)this.environment.getProperty(FLYWAY_VALIDATEON_MIGRATE, Boolean.class);
    }
}

