/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.List;
import org.egov.infra.admin.master.entity.Action;
import org.egov.infra.admin.master.entity.Feature;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.repository.FeatureRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FeatureService {
    @Autowired
    private FeatureRepository featureRepository;

    public List<Feature> getAllFeatures() {
        return this.featureRepository.findAll();
    }

    public List<Feature> getAllFeaturesByModuleId(Long moduleId) {
        return this.featureRepository.findByModuleId(moduleId);
    }

    public Feature getFeatureById(Long id) {
        return (Feature)this.featureRepository.findOne(id);
    }

    @Transactional
    public Feature saveFeature(Feature feature) {
        return (Feature)this.featureRepository.save(feature);
    }

    public Long getNumberOfFeatureByRoleAction(Role role, Action action) {
        return this.featureRepository.countByRolesInAndActionsIn(role, action);
    }
}

