/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.common.entity;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="eg_favourites", uniqueConstraints={@UniqueConstraint(columnNames={"userId", "actionId"})})
@SequenceGenerator(name="SEQ_EG_FAVOURITES", sequenceName="SEQ_EG_FAVOURITES", allocationSize=1)
public class Favourites
extends AbstractPersistable<Long> {
    private static final long serialVersionUID = 8966137226966715994L;
    public static final String SEQ_FAVOURITES = "SEQ_EG_FAVOURITES";
    @DocumentId
    @Id
    @GeneratedValue(generator="SEQ_EG_FAVOURITES", strategy=GenerationType.SEQUENCE)
    private Long id;
    private Long userId;
    private Integer actionId;
    @SafeHtml
    @NotBlank
    private String name;
    @SafeHtml
    @NotBlank
    private String contextRoot;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getActionId() {
        return this.actionId;
    }

    public void setActionId(Integer actionId) {
        this.actionId = actionId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actionId == null ? 0 : this.actionId.hashCode());
        result = 31 * result + (this.contextRoot == null ? 0 : this.contextRoot.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Favourites other = (Favourites)obj;
        if (this.actionId == null ? other.actionId != null : !this.actionId.equals(other.actionId)) {
            return false;
        }
        if (this.contextRoot == null ? other.contextRoot != null : !this.contextRoot.equals(other.contextRoot)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }
}

