/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infstr.utils;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class EGovConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(EGovConfig.class);
    private static Map<String, XMLConfiguration> configurationMap = new HashMap<String, XMLConfiguration>();
    private static Map<String, Properties> propertiesMap = new HashMap<String, Properties>();

    private EGovConfig() {
    }

    private static XMLConfiguration initializeClassVariable(String xmlFileName) {
        Class<EGovConfig> clazz = EGovConfig.class;
        synchronized (EGovConfig.class) {
            XMLConfiguration configuration = null;
            try {
                if (configurationMap.get(xmlFileName) == null) {
                    configuration = new XMLConfiguration(EGovConfig.toURL(xmlFileName));
                    configurationMap.put(xmlFileName, configuration);
                } else {
                    configuration = configurationMap.get(xmlFileName);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return configuration;
            }
            catch (ConfigurationException cex) {
                LOGGER.error("Error occurred in initializeClassVariable", (Throwable)cex);
                throw new ApplicationRuntimeException("Exception in initializeClassVariable", cex);
            }
            catch (Exception exp) {
                LOGGER.error("Error occurred in initializeClassVariable", (Throwable)exp);
                throw new ApplicationRuntimeException("Exception in initializeClassVariable", exp);
            }
            catch (Error exp) {
                LOGGER.error("Error occurred in initializeClassVariable", (Throwable)exp);
                throw new ApplicationRuntimeException("Exception in initializeClassVariable", exp);
            }
        }
    }

    private static URL toURL(String xmlFileName) {
        return xmlFileName.startsWith("config/") ? Thread.currentThread().getContextClassLoader().getResource(xmlFileName) : Thread.currentThread().getContextClassLoader().getResource("config/" + xmlFileName);
    }

    private static XMLConfiguration getXMLConfiguration(String xmlFileName) {
        return configurationMap.get(xmlFileName) == null ? EGovConfig.initializeClassVariable(xmlFileName) : configurationMap.get(xmlFileName);
    }

    public static String getProperty(String xmlFileName, String key, String defaultValue, String categoryName) {
        try {
            XMLConfiguration configurationXML = EGovConfig.getXMLConfiguration(xmlFileName);
            String output = configurationXML.getString(categoryName + "." + key);
            return output == null ? defaultValue : output;
        }
        catch (Exception exp) {
            LOGGER.error("Error occurred in while getting property from given xml file", (Throwable)exp);
            throw new ApplicationRuntimeException("Error occurred in while getting property from given xml file", exp);
        }
    }

    public static boolean getBooleanProperty(String xmlFileName, String name, boolean defaultValue, String categoryName) {
        Boolean output = EGovConfig.getXMLConfiguration(xmlFileName).getBoolean(categoryName + "." + name);
        return output != false ? output : defaultValue;
    }

    public static boolean getBooleanProperty(String xmlFileName, String name, boolean defaultValue) {
        Boolean output = EGovConfig.getXMLConfiguration(xmlFileName).getBoolean(name);
        return output != false ? output : defaultValue;
    }

    public static double getDoubleProperty(String xmlFileName, String name, double defaultValue) {
        double output = EGovConfig.getXMLConfiguration(xmlFileName).getDouble(name);
        return output == 0.0 ? defaultValue : output;
    }

    public static double getDoubleProperty(String xmlFileName, String name, double defaultValue, String category) {
        double output = EGovConfig.getXMLConfiguration(xmlFileName).getDouble(category + "." + name);
        return output == 0.0 ? defaultValue : output;
    }

    public static int getIntProperty(String xmlFileName, String name, int defaultValue) {
        int output = EGovConfig.getXMLConfiguration(xmlFileName).getInt(name);
        return output == 0 ? defaultValue : output;
    }

    public static int getIntProperty(String xmlFileName, String name, int defaultValue, String category) {
        int output = EGovConfig.getXMLConfiguration(xmlFileName).getInt(category + "." + name);
        return output == 0 ? defaultValue : output;
    }

    public static long getLongProperty(String xmlFileName, String name, long defaultValue) {
        long output = EGovConfig.getXMLConfiguration(xmlFileName).getLong(name);
        return output == 0L ? defaultValue : output;
    }

    public static long getLongProperty(String xmlFileName, String name, long defaultValue, String categoryName) {
        long output = EGovConfig.getXMLConfiguration(xmlFileName).getLong(categoryName + "." + name);
        return output == 0L ? defaultValue : output;
    }

    public static String[] getArray(String xmlFileName, String name) {
        return EGovConfig.getXMLConfiguration(xmlFileName).getStringArray(name);
    }

    public static String[] getArray(String xmlFileName, String name, String[] defaultValue) {
        String[] str = EGovConfig.getXMLConfiguration(xmlFileName).getStringArray(name);
        return str.length == 0 ? defaultValue : str;
    }

    public static String[] getArray(String xmlFileName, String name, String[] defaultValue, String category) {
        String[] str = EGovConfig.getXMLConfiguration(xmlFileName).getStringArray(category + "." + name);
        return str.length == 0 ? defaultValue : str;
    }

    public static String getMessage(String filename, String messageKey) {
        Properties properties = new Properties();
        try {
            if (propertiesMap.get(filename) == null) {
                properties.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(filename));
                propertiesMap.put(filename, properties);
            }
            properties = propertiesMap.get(filename);
        }
        catch (Exception exp) {
            LOGGER.error("Error Loading Properties File", (Throwable)exp);
        }
        return properties.getProperty(messageKey);
    }
}

