/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infstr.services;

import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;

public class Page {
    private final List results;
    private final Integer pageSize;
    private final int pageNumber;

    public Page(Query query, Integer pageNumber, Integer pageSize) {
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        this.pageNumber = pageNumber;
        if (pageSize != null && pageSize > 0) {
            query.setFirstResult((pageNumber - 1) * pageSize);
            query.setMaxResults(pageSize + 1);
            this.pageSize = pageSize;
        } else {
            this.pageSize = -1;
        }
        this.results = query.list();
    }

    public Page(Criteria criteria, Integer pageNumber, Integer pageSize) {
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        this.pageNumber = pageNumber;
        if (pageSize != null && pageSize > 0) {
            criteria.setFirstResult((pageNumber - 1) * pageSize);
            criteria.setMaxResults(pageSize + 1);
            this.pageSize = pageSize;
        } else {
            this.pageSize = -1;
        }
        this.results = criteria.list();
    }

    public boolean isNextPage() {
        return this.pageSize != -1 && this.results.size() > this.pageSize;
    }

    public boolean isPreviousPage() {
        return this.pageNumber > 0;
    }

    public List getList() {
        return this.isNextPage() ? this.results.subList(0, this.pageSize) : this.results;
    }

    public Integer getPageNo() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }
}

