/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.script.entity.Script;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.WorkflowAction;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;

public class SimpleWorkflowService<T extends StateAware>
implements WorkflowService<T> {
    private final PersistenceService<T, Long> stateAwarePersistenceService;
    private PersistenceService<WorkflowAction, Long> actionPersistenceService;
    @Autowired
    private ScriptService scriptService;

    public SimpleWorkflowService(PersistenceService<T, Long> stateAwarePersistenceService) {
        this.stateAwarePersistenceService = stateAwarePersistenceService;
    }

    public void setActionPersistenceService(PersistenceService<WorkflowAction, Long> actionPersistenceService) {
        this.actionPersistenceService = actionPersistenceService;
    }

    @Override
    public T transition(WorkflowAction workflowAction, T stateAware, String comments) {
        this.scriptService.executeScript(this.getScript(stateAware, workflowAction.getName()), ScriptService.createContext("action", this, "wfItem", stateAware, "persistenceService", this.stateAwarePersistenceService, "workflowService", this, "comments", comments));
        return (T)((StateAware)this.stateAwarePersistenceService.persist(stateAware));
    }

    @Override
    public T transition(String actionName, T stateAware, String comment) {
        List<WorkflowAction> workflowActions = this.actionPersistenceService.findAllByNamedQuery("BY_NAME_AND_TYPE", actionName, ((StateAware)stateAware).getStateType());
        WorkflowAction workflowAction = new WorkflowAction(actionName, ((StateAware)stateAware).getStateType(), actionName);
        if (!workflowActions.isEmpty()) {
            workflowAction = workflowActions.get(0);
        }
        return this.transition(workflowAction, stateAware, comment);
    }

    @Override
    public List<WorkflowAction> getValidActions(T stateAware) {
        String scriptName = ((StateAware)stateAware).getStateType() + ".workflow.validactions";
        Script trasitionScript = this.scriptService.getByName(scriptName);
        List actionNames = (List)this.scriptService.executeScript(trasitionScript, ScriptService.createContext("wfItem", stateAware, "workflowService", this, "persistenceService", this.stateAwarePersistenceService));
        List<WorkflowAction> savedWorkflowActions = this.actionPersistenceService.findAllByNamedQuery("IN_NAMES_AND_TYPE", ((StateAware)stateAware).getStateType(), actionNames);
        return savedWorkflowActions.isEmpty() ? this.createActions(stateAware, actionNames) : savedWorkflowActions;
    }

    public Object execute(T stateAware) {
        Script script = this.getScript(stateAware, "");
        return this.scriptService.executeScript(script, ScriptService.createContext("action", this, "wfItem", stateAware, "persistenceService", this.stateAwarePersistenceService));
    }

    public Object execute(T stateAware, String comments) {
        Script script = this.getScript(stateAware, "");
        return this.scriptService.executeScript(script, ScriptService.createContext("action", this, "wfItem", stateAware, "persistenceService", this.stateAwarePersistenceService, "comments", comments));
    }

    private Script getScript(T stateAware, String actionName) {
        Script script = null;
        if (!actionName.isEmpty()) {
            script = this.scriptService.getByName(((StateAware)stateAware).getStateType() + ".workflow." + actionName);
        }
        if (script == null) {
            script = this.scriptService.getByName(((StateAware)stateAware).getStateType() + ".workflow");
        }
        if (script == null) {
            throw new ApplicationRuntimeException("workflow.script.notfound");
        }
        return script;
    }

    private List<WorkflowAction> createActions(T stateAware, List<String> actionNames) {
        ArrayList<WorkflowAction> workflowActions = new ArrayList<WorkflowAction>();
        for (String action : actionNames) {
            workflowActions.add(new WorkflowAction(action, ((StateAware)stateAware).getStateType(), action));
        }
        return workflowActions;
    }

    @Override
    public WorkFlowMatrix getWfMatrix(String type, String department, BigDecimal amountRule, String additionalRule, String currentState, String pendingActions) {
        Criteria wfMatrixCriteria = this.createWfMatrixAdditionalCriteria(type, department, amountRule, additionalRule, currentState, pendingActions);
        return this.getWorkflowMatrixObj(type, additionalRule, currentState, pendingActions, wfMatrixCriteria);
    }

    @Override
    public WorkFlowMatrix getWfMatrix(String type, String department, BigDecimal amountRule, String additionalRule, String currentState, String pendingActions, Date date) {
        Criteria wfMatrixCriteria = this.createWfMatrixAdditionalCriteria(type, department, amountRule, additionalRule, currentState, pendingActions);
        if (null == date) {
            date = new Date();
        }
        SimpleExpression crit1 = Restrictions.le((String)"fromDate", (Object)date);
        SimpleExpression crit2 = Restrictions.ge((String)"toDate", (Object)date);
        Junction crit3 = Restrictions.conjunction().add((Criterion)crit1).add((Criterion)crit2);
        wfMatrixCriteria.add((Criterion)Restrictions.or((Criterion)crit3, (Criterion)crit1));
        return this.getWorkflowMatrixObj(type, additionalRule, currentState, pendingActions, wfMatrixCriteria);
    }

    private WorkFlowMatrix getWorkflowMatrixObj(String type, String additionalRule, String currentState, String pendingActions, Criteria wfMatrixCriteria) {
        List objectTypeList = wfMatrixCriteria.list();
        if (objectTypeList.isEmpty()) {
            Criteria defaulfWfMatrixCriteria = this.commonWorkFlowMatrixCriteria(type, additionalRule, currentState, pendingActions);
            defaulfWfMatrixCriteria.add((Criterion)Restrictions.eq((String)"department", (Object)"ANY"));
            List defaultObjectTypeList = defaulfWfMatrixCriteria.list();
            if (defaultObjectTypeList.isEmpty()) {
                return null;
            }
            return (WorkFlowMatrix)defaultObjectTypeList.get(0);
        }
        if (objectTypeList.size() > 0) {
            for (WorkFlowMatrix matrix : objectTypeList) {
                if (matrix.getToDate() != null) continue;
                return matrix;
            }
        }
        return (WorkFlowMatrix)objectTypeList.get(0);
    }

    private Criteria createWfMatrixAdditionalCriteria(String type, String department, BigDecimal amountRule, String additionalRule, String currentState, String pendingActions) {
        Criteria wfMatrixCriteria = this.commonWorkFlowMatrixCriteria(type, additionalRule, currentState, pendingActions);
        if (department != null && !"".equals(department.trim())) {
            wfMatrixCriteria.add((Criterion)Restrictions.eq((String)"department", (Object)department));
        }
        if (amountRule != null && BigDecimal.ZERO.compareTo(amountRule) != 0) {
            Junction amount1st = Restrictions.conjunction().add((Criterion)Restrictions.le((String)"fromQty", (Object)amountRule)).add((Criterion)Restrictions.ge((String)"toQty", (Object)amountRule));
            Junction amount2nd = Restrictions.conjunction().add((Criterion)Restrictions.le((String)"fromQty", (Object)amountRule)).add(Restrictions.isNull((String)"toQty"));
            wfMatrixCriteria.add((Criterion)Restrictions.disjunction().add((Criterion)amount1st).add((Criterion)amount2nd));
        }
        return wfMatrixCriteria;
    }

    public WorkFlowMatrix getPreviousStateFromWfMatrix(String type, String department, BigDecimal amountRule, String additionalRule, String currentState, String pendingActions) {
        List objectTypeList;
        Criteria wfMatrixCriteria = this.previousWorkFlowMatrixCriteria(type, additionalRule, currentState, pendingActions);
        if (department != null && !"".equals(department)) {
            wfMatrixCriteria.add((Criterion)Restrictions.eq((String)"department", (Object)department));
        } else {
            wfMatrixCriteria.add((Criterion)Restrictions.eq((String)"department", (Object)"ANY"));
        }
        if (amountRule != null && BigDecimal.ZERO.compareTo(amountRule) != 0) {
            Junction amount1st = Restrictions.conjunction().add((Criterion)Restrictions.le((String)"fromQty", (Object)amountRule)).add((Criterion)Restrictions.ge((String)"toQty", (Object)amountRule));
            Junction amount2nd = Restrictions.conjunction().add((Criterion)Restrictions.le((String)"fromQty", (Object)amountRule)).add(Restrictions.isNull((String)"toQty"));
            wfMatrixCriteria.add((Criterion)Restrictions.disjunction().add((Criterion)amount1st).add((Criterion)amount2nd));
        }
        if (!(objectTypeList = wfMatrixCriteria.list()).isEmpty()) {
            return (WorkFlowMatrix)objectTypeList.get(0);
        }
        return null;
    }

    private Criteria previousWorkFlowMatrixCriteria(String type, String additionalRule, String currentState, String pendingActions) {
        Criteria commonWfMatrixCriteria = this.stateAwarePersistenceService.getSession().createCriteria(WorkFlowMatrix.class);
        commonWfMatrixCriteria.add((Criterion)Restrictions.eq((String)"objectType", (Object)type));
        if (StringUtils.isNotBlank((String)additionalRule)) {
            commonWfMatrixCriteria.add((Criterion)Restrictions.eq((String)"additionalRule", (Object)additionalRule));
        }
        if (StringUtils.isNotBlank((String)pendingActions)) {
            commonWfMatrixCriteria.add(Restrictions.ilike((String)"nextAction", (String)pendingActions, (MatchMode)MatchMode.EXACT));
        }
        if (StringUtils.isNotBlank((String)currentState)) {
            commonWfMatrixCriteria.add(Restrictions.ilike((String)"nextState", (String)currentState, (MatchMode)MatchMode.EXACT));
        }
        return commonWfMatrixCriteria;
    }

    private Criteria commonWorkFlowMatrixCriteria(String type, String additionalRule, String currentState, String pendingActions) {
        Criteria commonWfMatrixCriteria = this.stateAwarePersistenceService.getSession().createCriteria(WorkFlowMatrix.class);
        commonWfMatrixCriteria.add((Criterion)Restrictions.eq((String)"objectType", (Object)type));
        if (additionalRule != null && !"".equals(additionalRule.trim())) {
            commonWfMatrixCriteria.add((Criterion)Restrictions.eq((String)"additionalRule", (Object)additionalRule));
        }
        if (pendingActions != null && !"".equals(pendingActions.trim())) {
            commonWfMatrixCriteria.add(Restrictions.ilike((String)"pendingActions", (String)pendingActions, (MatchMode)MatchMode.ANYWHERE));
        }
        if (currentState != null && !"".equals(currentState.trim())) {
            commonWfMatrixCriteria.add(Restrictions.ilike((String)"currentState", (String)currentState, (MatchMode)MatchMode.ANYWHERE));
        } else {
            commonWfMatrixCriteria.add(Restrictions.ilike((String)"currentState", (String)"NEW", (MatchMode)MatchMode.ANYWHERE));
        }
        return commonWfMatrixCriteria;
    }
}

