/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.matrix.service;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.egov.commons.EgwStatus;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.matrix.entity.WorkFlowAdditionalRule;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrixDetails;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkFlowMatrixService
extends PersistenceService<WorkFlowMatrix, Long> {
    private PersistenceService persistenceService;
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkFlowMatrixService.class);
    public static final String OBJECTTYPE = "ObjectType";
    public static final String ADDITIONALRULE = "AdditionalRule";
    public static final String FROMDATE = "FromDate";
    public static final String TODATE = "ToDate";
    public static final String FROMAMOUNT = "FromAmount";
    public static final String TOAMOUNT = "ToAmount";
    public static final String DEPARTMENTS = "Departments";
    public static final String MODIFYDATE = "ModifyDate";
    public static final String DEFAULT = "DEFAULT";
    public static final String REJECTED = "Rejected";
    private Boolean isworkFlowCorrect;

    public Boolean getIsworkFlowCorrect() {
        return this.isworkFlowCorrect;
    }

    public void setIsworkFlowCorrect(Boolean isworkFlowCorrect) {
        this.isworkFlowCorrect = isworkFlowCorrect;
    }

    public List<Department> getdepartmentList() {
        return this.persistenceService.findAllBy("from Department order by deptName asc", new Object[0]);
    }

    public List<WorkflowTypes> getobjectTypeList() {
        return this.persistenceService.findAllBy("from org.egov.infstr.models.WorkflowTypes order by type asc", new Object[0]);
    }

    public WorkflowTypes getobjectTypebyId(Long objectTypeId) {
        return (WorkflowTypes)this.persistenceService.find("from org.egov.infstr.models.WorkflowTypes where id=? order by type asc", objectTypeId);
    }

    public WorkflowTypes getobjectTypebyName(String objectTypeName) {
        return (WorkflowTypes)this.persistenceService.find("from org.egov.infstr.models.WorkflowTypes where type=? order by type asc", objectTypeName);
    }

    public List getAdditionalRulesforObject(Long objectTypeid) {
        Criteria crit = this.getSession().createCriteria(WorkFlowAdditionalRule.class);
        crit.add((Criterion)Restrictions.eq((String)"objecttypeid.id", (Object)objectTypeid));
        return crit.list();
    }

    public List<Designation> getdesignationList() {
        return this.persistenceService.findAllBy("from Designation order by name asc", new Object[0]);
    }

    public HashMap<String, List> getDetailsforObject(Long workFlowObjectId) {
        LOGGER.info("getDetailsforObject Method is called");
        ArrayList<String> stateList = new ArrayList<String>();
        ArrayList<String> statusList = new ArrayList<String>();
        ArrayList<String> buttonList = new ArrayList<String>();
        ArrayList<String> objactionList = new ArrayList<String>();
        HashMap<String, List> detailMap = new HashMap<String, List>();
        Criteria stateCrit = this.getSession().createCriteria(WorkFlowAdditionalRule.class);
        stateCrit.add((Criterion)Restrictions.eq((String)"objecttypeid.id", (Object)workFlowObjectId));
        List workFlowAdditionalList = new ArrayList();
        workFlowAdditionalList = stateCrit.list();
        for (WorkFlowAdditionalRule wfAdditionalrule : workFlowAdditionalList) {
            StringTokenizer strngtkn;
            if (wfAdditionalrule != null && wfAdditionalrule.getStates() != null && wfAdditionalrule.getStates() != "") {
                strngtkn = new StringTokenizer(wfAdditionalrule.getStates(), ",");
                while (strngtkn.hasMoreTokens()) {
                    String statetkn = strngtkn.nextToken();
                    if (stateList.contains(statetkn)) continue;
                    stateList.add(statetkn);
                }
            }
            if (wfAdditionalrule != null && wfAdditionalrule.getStatus() != null && wfAdditionalrule.getStatus() != "") {
                strngtkn = new StringTokenizer(wfAdditionalrule.getStatus(), ",");
                while (strngtkn.hasMoreTokens()) {
                    String moduleType = strngtkn.nextToken();
                    List statusLists = this.persistenceService.findAllBy("from EgwStatus where moduletype=? order by code asc", moduleType);
                    for (EgwStatus status : statusLists) {
                        if (status == null || status.getCode() == null || statusList.contains(status.getCode())) continue;
                        statusList.add(status.getCode());
                    }
                }
            }
            if (wfAdditionalrule != null && wfAdditionalrule.getButtons() != null && wfAdditionalrule.getButtons() != "") {
                StringTokenizer btntkn = new StringTokenizer(wfAdditionalrule.getButtons(), ",");
                while (btntkn.hasMoreTokens()) {
                    String buttontkn = btntkn.nextToken();
                    if (buttonList.contains(buttontkn)) continue;
                    buttonList.add(buttontkn);
                }
            }
            if (wfAdditionalrule == null || wfAdditionalrule.getWorkFlowActions() == null || wfAdditionalrule.getWorkFlowActions() == "") continue;
            StringTokenizer acttkn = new StringTokenizer(wfAdditionalrule.getWorkFlowActions(), ",");
            while (acttkn.hasMoreTokens()) {
                String objactiontkn = acttkn.nextToken();
                if (objactionList.contains(objactiontkn)) continue;
                objactionList.add(objactiontkn);
            }
        }
        if (stateList.isEmpty()) {
            stateList.add("Created");
            stateList.add("Checked");
            stateList.add("Approved");
            stateList.add("Inspected");
            stateList.add("Submitted");
            stateList.add("ReSubmitted");
            stateList.add(REJECTED);
        }
        if (statusList.isEmpty()) {
            statusList.add("Created");
            statusList.add("Approved");
            statusList.add(REJECTED);
            statusList.add("Submitted");
            statusList.add("Closed");
        }
        if (buttonList.isEmpty()) {
            buttonList.add("Forward");
            buttonList.add("Approve");
            buttonList.add("Reject");
            buttonList.add("Close");
        }
        if (objactionList.isEmpty()) {
            objactionList.add("Pending Check");
            objactionList.add("Pending Approval");
            objactionList.add("Pending Close");
            objactionList.add("END");
        }
        detailMap.put("StateList", stateList);
        detailMap.put("StatusList", statusList);
        detailMap.put("ButtonsList", buttonList);
        detailMap.put("ActionsList", objactionList);
        LOGGER.info("getDetailsforObject Method is ended");
        return detailMap;
    }

    public void save(List<WorkFlowMatrix> actualWorkFlowMatrixDetails, String[] departments) {
        LOGGER.info("save Method is called");
        for (String dept : departments) {
            for (WorkFlowMatrix workFlowMatrix : actualWorkFlowMatrixDetails) {
                WorkFlowMatrix wfObj = workFlowMatrix.clone();
                if (dept.equals(DEFAULT)) {
                    wfObj.setDepartment("ANY");
                } else {
                    wfObj.setDepartment(dept);
                }
                this.getSession().save((Object)wfObj);
            }
        }
        this.getSession().flush();
        LOGGER.info("save Method is ended");
    }

    public List<WorkFlowMatrixDetails> getWorkFlowMatrixObjectForView(HashMap workFlowObjectMap) {
        LOGGER.info("save Method is called");
        Criteria workFlowCrit = this.getSession().createCriteria(WorkFlowMatrix.class);
        if (workFlowObjectMap.get(OBJECTTYPE) != null && workFlowObjectMap.get(OBJECTTYPE) != "-1") {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"objectType", (Object)this.getobjectTypebyId((Long)workFlowObjectMap.get(OBJECTTYPE)).getType()));
        }
        if (workFlowObjectMap.get(DEPARTMENTS) != null && workFlowObjectMap.get(DEPARTMENTS) != "-1") {
            String[] department = (String[])workFlowObjectMap.get(DEPARTMENTS);
            workFlowCrit.add((Criterion)Restrictions.eq((String)"department", (Object)department[0]));
        }
        if (workFlowObjectMap.get(ADDITIONALRULE) != null && !workFlowObjectMap.get(ADDITIONALRULE).equals("-1")) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"additionalRule", workFlowObjectMap.get(ADDITIONALRULE)));
        }
        this.addProjectionsforCriteria(workFlowCrit);
        workFlowCrit.addOrder(Order.asc((String)"fromDate"));
        workFlowCrit.addOrder(Order.asc((String)"fromQty"));
        workFlowCrit.addOrder(Order.asc((String)"additionalRule"));
        workFlowCrit.setResultTransformer(Transformers.aliasToBean(WorkFlowMatrixDetails.class));
        List workFlowList = workFlowCrit.list();
        if (workFlowList.size() != 0) {
            List<WorkFlowMatrixDetails> actList = this.checkWithOtherParams(workFlowList, workFlowObjectMap);
            return this.prepareWorkFlowResult(actList);
        }
        return null;
    }

    private void addProjectionsforCriteria(Criteria workFlowCrit) {
        workFlowCrit.setProjection((Projection)Projections.projectionList().add(Projections.groupProperty((String)"objectType").as("objectTypeAlias")).add(Projections.groupProperty((String)"department").as("departmentAlias")).add(Projections.groupProperty((String)"additionalRule").as("additionalRuleAlias")).add(Projections.groupProperty((String)"fromQty").as("fromQtyAlias")).add(Projections.groupProperty((String)"toQty").as("toQtyAlias")).add(Projections.groupProperty((String)"fromDate").as("fromDateAlias")).add(Projections.groupProperty((String)"toDate").as("toDateAlias")));
    }

    private List<WorkFlowMatrixDetails> prepareWorkFlowResult(List<WorkFlowMatrixDetails> matrixdetList) {
        LOGGER.info("prepareWorkFlowResult Method is called");
        for (WorkFlowMatrixDetails det : matrixdetList) {
            det.setObjectTypeDisplay(this.getobjectTypebyName(det.getObjectType()).getDisplayName());
            List<WorkFlowMatrix> workFlowdet = this.getMatrixdetails(det);
            List<WorkFlowMatrixDetails> detailsList = new LinkedList<WorkFlowMatrixDetails>();
            detailsList = this.prepareWorkFlowMatrixDetailsList(this.sortListbyActions(workFlowdet), detailsList, Boolean.TRUE);
            det.setMatrixdetails(detailsList);
        }
        LOGGER.info("prepareWorkFlowResult Method is ended");
        return matrixdetList;
    }

    public List prepareWorkFlowMatrixDetailsList(List<WorkFlowMatrix> workFlowdet, List<WorkFlowMatrixDetails> detailsList, Boolean isReject) {
        for (WorkFlowMatrix wfMatrixObj : workFlowdet) {
            String[] desnarr;
            String[] buttonarr;
            WorkFlowMatrixDetails details = new WorkFlowMatrixDetails();
            if (isReject.booleanValue()) {
                details.setAction(wfMatrixObj.getNextAction());
                details.setState(wfMatrixObj.getNextState());
                details.setStatus(wfMatrixObj.getNextStatus());
                buttonarr = new String[]{""};
                if (wfMatrixObj.getValidActions() != null) {
                    buttonarr = wfMatrixObj.getValidActions().split(",");
                }
                details.setButtons(buttonarr);
                desnarr = new String[]{""};
                if (wfMatrixObj.getNextDesignation() != null) {
                    desnarr = wfMatrixObj.getNextDesignation().split(",");
                }
                details.setDesignation(desnarr);
                details.setStatus(wfMatrixObj.getNextStatus());
            } else {
                details.setRejectAction(wfMatrixObj.getNextAction());
                details.setRejectState(wfMatrixObj.getNextState());
                details.setRejectStatus(wfMatrixObj.getNextStatus());
                buttonarr = new String[]{""};
                if (wfMatrixObj.getValidActions() != null) {
                    buttonarr = wfMatrixObj.getValidActions().split(",");
                }
                details.setRejectButtons(buttonarr);
                desnarr = new String[]{""};
                if (wfMatrixObj.getNextDesignation() != null) {
                    desnarr = wfMatrixObj.getNextDesignation().split(",");
                }
                details.setRejectDesignation(desnarr);
                details.setRejectStatus(wfMatrixObj.getNextStatus());
            }
            detailsList.add(details);
        }
        return detailsList;
    }

    private List sortListbyActions(List<WorkFlowMatrix> workFlowdet) {
        LOGGER.info("sortListbyActions Method is called");
        this.setIsworkFlowCorrect(Boolean.TRUE);
        LinkedList<WorkFlowMatrix> unsortedList = new LinkedList<WorkFlowMatrix>(workFlowdet);
        WorkFlowMatrix rejectedMatrix = null;
        LinkedList<WorkFlowMatrix> workflowSortedList = new LinkedList<WorkFlowMatrix>();
        LinkedList<WorkFlowMatrix> rejectedRelatedList = new LinkedList<WorkFlowMatrix>();
        Iterator<WorkFlowMatrix> workFlowdetiterator = workFlowdet.iterator();
        while (workFlowdetiterator.hasNext()) {
            WorkFlowMatrix wfMatrix = workFlowdetiterator.next();
            if (wfMatrix.getPendingActions() != null || !wfMatrix.getCurrentState().equalsIgnoreCase("NEW")) continue;
            workflowSortedList.add(wfMatrix);
            workFlowdetiterator.remove();
        }
        while (workflowSortedList.size() > 0 && !((WorkFlowMatrix)workflowSortedList.get(workflowSortedList.size() - 1)).getNextAction().equalsIgnoreCase("END")) {
            int size = workFlowdet.size();
            String sortedwfMatrixnextAction = ((WorkFlowMatrix)workflowSortedList.get(workflowSortedList.size() - 1)).getNextAction();
            String sortedwfMatrixnextState = ((WorkFlowMatrix)workflowSortedList.get(workflowSortedList.size() - 1)).getNextState();
            int count = 0;
            for (WorkFlowMatrix wfMatrix : workFlowdet) {
                if (sortedwfMatrixnextAction.equalsIgnoreCase(wfMatrix.getPendingActions()) && sortedwfMatrixnextState.equalsIgnoreCase(wfMatrix.getCurrentState())) {
                    workflowSortedList.add(wfMatrix);
                    continue;
                }
                if (++count < size) continue;
                this.setIsworkFlowCorrect(Boolean.FALSE);
                break;
            }
            if (this.isworkFlowCorrect.booleanValue()) {
                for (int j = 0; j < workFlowdet.size(); ++j) {
                    Long actwfMatrixnextAction = workFlowdet.get(j).getId();
                    for (WorkFlowMatrix wfMatrix : workflowSortedList) {
                        if (!actwfMatrixnextAction.equals(wfMatrix.getId())) continue;
                        workFlowdet.remove(j);
                    }
                }
            }
            if (this.isworkFlowCorrect.booleanValue()) continue;
            break;
        }
        if (this.isworkFlowCorrect.booleanValue()) {
            Iterator<WorkFlowMatrix> rejectworkFlowdetiterator = workFlowdet.iterator();
            while (rejectworkFlowdetiterator.hasNext()) {
                WorkFlowMatrix wfMatrix = rejectworkFlowdetiterator.next();
                if (!wfMatrix.getCurrentState().equalsIgnoreCase(REJECTED)) continue;
                rejectedMatrix = wfMatrix;
                for (WorkFlowMatrix wfmatrix : workFlowdet) {
                    if (!wfMatrix.getNextAction().equalsIgnoreCase(wfmatrix.getPendingActions()) || !wfMatrix.getNextState().equalsIgnoreCase(wfmatrix.getCurrentState())) continue;
                    rejectedRelatedList.add(wfmatrix);
                }
                rejectworkFlowdetiterator.remove();
            }
            if (rejectedMatrix != null) {
                workflowSortedList.add(rejectedMatrix);
            }
            for (WorkFlowMatrix wfMatrix : rejectedRelatedList) {
                if (wfMatrix == null || workflowSortedList.contains(wfMatrix)) continue;
                workflowSortedList.add(wfMatrix);
            }
            LOGGER.info("sortListbyActions Method is ended");
            return workflowSortedList;
        }
        return unsortedList;
    }

    private List<WorkFlowMatrix> getMatrixdetails(WorkFlowMatrixDetails det) {
        LOGGER.info("getMatrixdetails Method is called");
        Criteria workFlowCrit = this.getSession().createCriteria(WorkFlowMatrix.class);
        if (det.getObjectType() != null) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"objectType", (Object)det.getObjectType()));
        }
        if (det.getAdditionalRule() != null) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"additionalRule", (Object)det.getAdditionalRule()));
        } else {
            workFlowCrit.add(Restrictions.isNull((String)"additionalRule"));
        }
        if (det.getDepartment() != null) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"department", (Object)det.getDepartment()));
        }
        if (det.getFromDate() != null) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"fromDate", (Object)det.getFromDate()));
        }
        if (det.getToDate() != null) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"toDate", (Object)det.getToDate()));
        } else {
            workFlowCrit.add(Restrictions.isNull((String)"toDate"));
        }
        if (det.getFromQty() != null) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"fromQty", (Object)det.getFromQty()));
        } else {
            workFlowCrit.add(Restrictions.isNull((String)"fromQty"));
        }
        if (det.getToQty() != null) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"toQty", (Object)det.getToQty()));
        } else {
            workFlowCrit.add(Restrictions.isNull((String)"toQty"));
        }
        LOGGER.info("getMatrixdetails Method is ended");
        return workFlowCrit.list();
    }

    private List<WorkFlowMatrixDetails> checkWithOtherParams(List<WorkFlowMatrixDetails> workFlowList, HashMap workFlowObjectMap) {
        Iterator matrixiterator;
        WorkFlowMatrixDetails matrixdet2;
        LOGGER.info("checkWithOtherParams Method is called");
        ArrayList<WorkFlowMatrixDetails> tempList1 = new ArrayList<WorkFlowMatrixDetails>();
        Date fromdate = null;
        Date todate = null;
        BigDecimal fromqty = null;
        BigDecimal toqty = null;
        if (workFlowObjectMap.get(FROMDATE) != null && workFlowObjectMap.get(FROMDATE) != "") {
            fromdate = (Date)workFlowObjectMap.get(FROMDATE);
        }
        if (workFlowObjectMap.get(TODATE) != null && workFlowObjectMap.get(TODATE) != "") {
            todate = (Date)workFlowObjectMap.get(TODATE);
        }
        if (workFlowObjectMap.get(FROMAMOUNT) != null && workFlowObjectMap.get(FROMAMOUNT) != "") {
            fromqty = (BigDecimal)workFlowObjectMap.get(FROMAMOUNT);
        }
        if (workFlowObjectMap.get(TOAMOUNT) != null && workFlowObjectMap.get(TOAMOUNT) != "") {
            toqty = (BigDecimal)workFlowObjectMap.get(TOAMOUNT);
        }
        if (fromdate != null && todate == null) {
            for (WorkFlowMatrixDetails matrixdet2 : workFlowList) {
                if (matrixdet2.getToDate() == null && matrixdet2.getFromDate() != null && !fromdate.before(matrixdet2.getFromDate())) {
                    tempList1.add(matrixdet2);
                    continue;
                }
                if (!fromdate.before(matrixdet2.getFromDate()) && !fromdate.equals(matrixdet2.getFromDate())) continue;
                tempList1.add(matrixdet2);
            }
        }
        if (fromdate != null && todate != null) {
            for (WorkFlowMatrixDetails matrixdet2 : workFlowList) {
                if (!fromdate.before(matrixdet2.getFromDate()) && !fromdate.equals(matrixdet2.getFromDate()) || !todate.after(matrixdet2.getToDate()) && !todate.equals(matrixdet2.getToDate())) continue;
                tempList1.add(matrixdet2);
            }
        }
        if (fromdate == null && todate == null) {
            tempList1.addAll(workFlowList);
        }
        if (fromqty != null && toqty == null) {
            matrixiterator = tempList1.iterator();
            while (matrixiterator.hasNext()) {
                matrixdet2 = (WorkFlowMatrixDetails)matrixiterator.next();
                if (matrixdet2.getFromQty() != null && (matrixdet2.getFromQty() == null || fromqty.compareTo(matrixdet2.getFromQty()) <= 0)) continue;
                matrixiterator.remove();
            }
        } else if (fromqty != null && toqty != null) {
            matrixiterator = tempList1.iterator();
            while (matrixiterator.hasNext()) {
                matrixdet2 = (WorkFlowMatrixDetails)matrixiterator.next();
                if (matrixdet2.getFromQty() == null || matrixdet2.getToQty() == null) {
                    matrixiterator.remove();
                    continue;
                }
                if (matrixdet2.getToQty() != null && matrixdet2.getToQty() != null && fromqty.doubleValue() >= matrixdet2.getFromQty().doubleValue() && toqty.doubleValue() <= matrixdet2.getToQty().doubleValue()) continue;
                matrixiterator.remove();
            }
        } else if (fromqty == null && toqty != null) {
            matrixiterator = tempList1.iterator();
            while (matrixiterator.hasNext()) {
                matrixdet2 = (WorkFlowMatrixDetails)matrixiterator.next();
                if (matrixdet2.getFromQty() == null) {
                    matrixiterator.remove();
                }
                if (matrixdet2.getToQty() != null) {
                    if (toqty.compareTo(matrixdet2.getToQty()) >= 0) continue;
                    matrixiterator.remove();
                    continue;
                }
                if (toqty.compareTo(matrixdet2.getFromQty()) >= 0) continue;
                matrixiterator.remove();
            }
        }
        LOGGER.info("checkWithOtherParams Method is ended");
        if (fromqty == null && toqty == null && fromdate == null && todate == null) {
            return workFlowList;
        }
        return tempList1;
    }

    public List checkIfMatrixExists(HashMap workflowheaderparams) {
        LOGGER.info("checkIfMatrixExists Method is called");
        StringBuffer dateQryStr = new StringBuffer();
        StringBuffer qntyQryStr = new StringBuffer();
        this.prepareQuery(workflowheaderparams, dateQryStr);
        this.prepareQuery(workflowheaderparams, qntyQryStr);
        dateQryStr.append(" having  fromDate <= :fromdate  and toDate is null ");
        dateQryStr.append(" or fromDate <= :fromdate  and toDate>= :fromdate   ");
        if (workflowheaderparams.get(TODATE) != null && !workflowheaderparams.get(TODATE).equals("")) {
            dateQryStr.append(" or fromDate <= :todate  and toDate>= :todate   ");
        }
        Query datequery = this.getSession().createQuery(new String(dateQryStr));
        this.addParameter(workflowheaderparams, datequery);
        datequery.setParameter("fromdate", workflowheaderparams.get(FROMDATE));
        if (workflowheaderparams.get(TODATE) != null && !workflowheaderparams.get(TODATE).equals("")) {
            datequery.setParameter("todate", workflowheaderparams.get(TODATE));
        }
        List dateList = datequery.list();
        if (workflowheaderparams.get(FROMAMOUNT) != null && !workflowheaderparams.get(FROMAMOUNT).equals("")) {
            qntyQryStr.append(" having  fromQty <= :fromamount  and toQty is null ");
            qntyQryStr.append(" or fromQty <= :fromamount  and toQty>= :fromamount   ");
        }
        if (workflowheaderparams.get(TOAMOUNT) != null && !workflowheaderparams.get(TOAMOUNT).equals("")) {
            qntyQryStr.append(" or fromQty <= :toamount  and toQty>= :toamount   ");
        }
        Query qntyquery = this.getSession().createQuery(new String(qntyQryStr));
        this.addParameter(workflowheaderparams, qntyquery);
        if (workflowheaderparams.get(FROMAMOUNT) != null && !workflowheaderparams.get(FROMAMOUNT).equals("")) {
            qntyquery.setParameter("fromamount", workflowheaderparams.get(FROMAMOUNT));
        }
        if (workflowheaderparams.get(TOAMOUNT) != null && !workflowheaderparams.get(TOAMOUNT).equals("")) {
            qntyquery.setParameter("toamount", workflowheaderparams.get(TOAMOUNT));
        }
        List qntyList = qntyquery.list();
        dateList.retainAll(qntyList);
        LOGGER.info("checkIfMatrixExists Method is ended");
        if (dateList.size() > 0) {
            return dateList;
        }
        return null;
    }

    private void prepareQuery(HashMap workflowheaderparams, StringBuffer QryStr) {
        LOGGER.info("prepareQuery Method is called");
        QryStr.append("select id from  WorkFlowMatrix  where objectType = :objecttype and department IN (:departments) ");
        if (workflowheaderparams.get(ADDITIONALRULE) != null && !workflowheaderparams.get(ADDITIONALRULE).equals("-1")) {
            QryStr.append("and additionalRule = :additionalrule");
        }
        QryStr.append(" group by id,objectType,department,fromDate,toDate,fromQty,toQty ");
        if (workflowheaderparams.get(ADDITIONALRULE) != null && !workflowheaderparams.get(ADDITIONALRULE).equals("-1")) {
            QryStr.append(",additionalRule ");
        }
        LOGGER.info("prepareQuery Method is ended");
    }

    private void addParameter(HashMap workflowheaderparams, Query datequery) {
        datequery.setParameter("objecttype", (Object)this.getobjectTypebyId((Long)workflowheaderparams.get(OBJECTTYPE)).getType());
        if (workflowheaderparams.get(ADDITIONALRULE) != null && !workflowheaderparams.get(ADDITIONALRULE).equals("-1")) {
            datequery.setParameter("additionalrule", workflowheaderparams.get(ADDITIONALRULE));
        }
        datequery.setParameterList("departments", (Object[])((String[])workflowheaderparams.get(DEPARTMENTS)));
    }

    public void deleteWorkFlowforObject(HashMap workflowsearchparams) {
        Criteria workFlowCrit = this.getCriteriaForDeleteorModify(workflowsearchparams);
        for (WorkFlowMatrix matrix : workFlowCrit.list()) {
            this.getSession().delete((Object)matrix);
        }
        this.getSession().flush();
    }

    public List getWorkFlowforObjectforModify(HashMap workflowsearchparams) {
        Criteria workFlowCrit = this.getCriteriaForDeleteorModify(workflowsearchparams);
        List matrixList = workFlowCrit.list();
        return this.sortListbyActions(matrixList);
    }

    private Criteria getCriteriaForDeleteorModify(HashMap workflowsearchparams) {
        LOGGER.info("getCriteriaForDeleteorModify Method is called");
        Criteria workFlowCrit = this.getSession().createCriteria(WorkFlowMatrix.class);
        if (workflowsearchparams.get(OBJECTTYPE) != null && !workflowsearchparams.get(OBJECTTYPE).equals("")) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"objectType", workflowsearchparams.get(OBJECTTYPE)));
        }
        if (workflowsearchparams.get(ADDITIONALRULE) != null && !workflowsearchparams.get(ADDITIONALRULE).equals("") && !workflowsearchparams.get(ADDITIONALRULE).equals("-1")) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"additionalRule", workflowsearchparams.get(ADDITIONALRULE)));
        }
        if (workflowsearchparams.get(DEPARTMENTS) != null && !workflowsearchparams.get(DEPARTMENTS).equals("")) {
            String[] department = (String[])workflowsearchparams.get(DEPARTMENTS);
            workFlowCrit.add((Criterion)Restrictions.eq((String)"department", (Object)department[0]));
        }
        if (workflowsearchparams.get(FROMDATE) != null && !workflowsearchparams.get(FROMDATE).equals("")) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"fromDate", workflowsearchparams.get(FROMDATE)));
        }
        if (workflowsearchparams.get(TODATE) != null && !workflowsearchparams.get(TODATE).equals("")) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"toDate", workflowsearchparams.get(TODATE)));
        }
        if (workflowsearchparams.get(FROMAMOUNT) != null && !workflowsearchparams.get(FROMAMOUNT).equals("")) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"fromQty", workflowsearchparams.get(FROMAMOUNT)));
        }
        if (workflowsearchparams.get(TOAMOUNT) != null && !workflowsearchparams.get(TOAMOUNT).equals("")) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"toQty", workflowsearchparams.get(TOAMOUNT)));
        }
        LOGGER.info("getCriteriaForDeleteorModify Method is ended");
        return workFlowCrit;
    }

    public Boolean updateWorkFlowforObject(HashMap workflowparams) {
        LOGGER.info("updateWorkFlowforObject Method is called");
        Criteria workFlowCrit = this.getCriteriaForDeleteorModify(workflowparams);
        Iterator iterator = workFlowCrit.list().iterator();
        while (iterator.hasNext()) {
            WorkFlowMatrix matrix;
            matrix.setToDate((matrix = (WorkFlowMatrix)iterator.next()).getToDate() != null ? matrix.getToDate() : (workflowparams.get(MODIFYDATE) != null ? (Date)workflowparams.get(MODIFYDATE) : new Date()));
            if (matrix.getFromDate().equals(matrix.getToDate())) {
                return false;
            }
            this.getSession().update((Object)matrix);
        }
        this.getSession().flush();
        LOGGER.info("updateWorkFlowforObject Method is ended");
        return true;
    }

    public Date checkLegacyMatrix(HashMap workflowheaderparams) {
        LOGGER.info("checkLegacyMatrix Method is called");
        Criteria workFlowCrit = this.getSession().createCriteria(WorkFlowMatrix.class);
        if (workflowheaderparams.get(OBJECTTYPE) != null && workflowheaderparams.get(OBJECTTYPE) != "") {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"objectType", (Object)this.getobjectTypebyId((Long)workflowheaderparams.get(OBJECTTYPE)).getType()));
        }
        if (workflowheaderparams.get(ADDITIONALRULE) != null && !workflowheaderparams.get(ADDITIONALRULE).equals("-1")) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"additionalRule", workflowheaderparams.get(ADDITIONALRULE)));
        }
        if (workflowheaderparams.get(DEPARTMENTS) != null && workflowheaderparams.get(DEPARTMENTS) != "") {
            String[] department = (String[])workflowheaderparams.get(DEPARTMENTS);
            workFlowCrit.add((Criterion)Restrictions.eq((String)"department", (Object)department[0]));
        }
        if (workflowheaderparams.get(FROMDATE) != null && workflowheaderparams.get(FROMDATE) != "") {
            workFlowCrit.add((Criterion)Restrictions.ge((String)"fromDate", workflowheaderparams.get(FROMDATE)));
        }
        if (workflowheaderparams.get(FROMAMOUNT) != null && workflowheaderparams.get(FROMAMOUNT) != "") {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"fromQty", workflowheaderparams.get(FROMAMOUNT)));
        }
        if (workflowheaderparams.get(TOAMOUNT) != null && workflowheaderparams.get(TOAMOUNT) != "") {
            workFlowCrit.add((Criterion)Restrictions.eq((String)"toQty", workflowheaderparams.get(TOAMOUNT)));
        }
        this.addProjectionsforCriteria(workFlowCrit);
        workFlowCrit.addOrder(Order.asc((String)"toDate"));
        workFlowCrit.setResultTransformer(Transformers.aliasToBean(WorkFlowMatrixDetails.class));
        List matrixList = workFlowCrit.list();
        LOGGER.info("checkLegacyMatrix Method is ended");
        if (matrixList.size() > 0) {
            return ((WorkFlowMatrixDetails)matrixList.get(0)).getFromDateAlias();
        }
        return null;
    }

    public WorkFlowMatrix getWorkFlowObjectbyId(Long matrixid) {
        return (WorkFlowMatrix)this.getSession().get(WorkFlowMatrix.class, (Serializable)matrixid);
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

