/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.matrix.service;

import java.util.List;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.matrix.entity.WorkFlowAdditionalRule;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkFlowAdditionalDetailsService
extends PersistenceService<WorkFlowAdditionalRule, Long> {
    private PersistenceService persistenceService;
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkFlowAdditionalDetailsService.class);

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public WorkflowTypes getobjectTypebyId(Long objectTypeId) {
        return (WorkflowTypes)this.persistenceService.find("from org.egov.infstr.models.WorkflowTypes where id=? order by type asc", objectTypeId);
    }

    public List getAllModuleTypeforStatus() {
        return this.persistenceService.findAllBy(" select distinct(moduletype) from EgwStatus order by moduletype asc", new Object[0]);
    }

    public List<WorkflowTypes> getobjectTypeList() {
        return this.persistenceService.findAllBy("from org.egov.infstr.models.WorkflowTypes order by type asc", new Object[0]);
    }

    public WorkFlowAdditionalRule save(WorkFlowAdditionalRule wfAdditionalRule) {
        LOGGER.info("save Method is called");
        wfAdditionalRule = wfAdditionalRule.getId() == null ? this.persist(wfAdditionalRule) : this.merge(wfAdditionalRule);
        LOGGER.info("save Method is Ended");
        return wfAdditionalRule;
    }

    public List<WorkFlowAdditionalRule> getAdditionalRulesbyObject(Long objectType) {
        LOGGER.info("getAdditionalRulesbyObject Method is called");
        Criteria crit = this.getSession().createCriteria(WorkFlowAdditionalRule.class);
        crit.add((Criterion)Restrictions.eq((String)"objecttypeid.id", (Object)objectType));
        LOGGER.info("getAdditionalRulesbyObject Method is ended");
        return crit.list();
    }

    public WorkFlowAdditionalRule getObjectbyTypeandRule(Long objectType, String additionalRules) {
        LOGGER.info("getObjectbyTypeandRule Method is called");
        Criteria crit = this.getSession().createCriteria(WorkFlowAdditionalRule.class);
        crit.add((Criterion)Restrictions.eq((String)"objecttypeid.id", (Object)objectType));
        if (additionalRules == null || additionalRules.equals("-1")) {
            crit.add(Restrictions.isNull((String)"additionalRule"));
        } else {
            crit.add((Criterion)Restrictions.eq((String)"additionalRule", (Object)additionalRules));
        }
        if (crit.list().size() != 0) {
            return (WorkFlowAdditionalRule)crit.list().get(0);
        }
        return null;
    }

    public WorkFlowAdditionalRule getObjectbyTypeandRule(Long ObjectId, Long objectType, String additionalRules) {
        LOGGER.info("getObjectbyTypeandRule Method is called");
        Criteria crit = this.getSession().createCriteria(WorkFlowAdditionalRule.class);
        crit.add((Criterion)Restrictions.eq((String)"objecttypeid.id", (Object)objectType));
        crit.add((Criterion)Restrictions.ne((String)"id", (Object)ObjectId));
        if (additionalRules == null) {
            crit.add(Restrictions.isNull((String)"additionalRule"));
        } else {
            crit.add((Criterion)Restrictions.eq((String)"additionalRule", (Object)additionalRules));
        }
        if (crit.list().size() != 0) {
            return (WorkFlowAdditionalRule)crit.list().get(0);
        }
        return null;
    }
}

