/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.inbox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.entity.WorkflowAction;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.inbox.InboxRenderService;
import org.egov.infstr.services.EISServeable;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class InboxRenderServiceDeligate<T extends StateAware> {
    private static final Logger LOG = LoggerFactory.getLogger(InboxRenderServiceDeligate.class);
    public static final String UNKNOWN = "Unknown";
    public static final String SLASH_DELIMIT = " / ";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private PersistenceService<State, Long> statePersistenceService;
    @Autowired
    private PersistenceService<WorkflowTypes, Long> workflowTypePersistenceService;
    @Qualifier(value="entityQueryService")
    @Autowired
    private PersistenceService entityQueryService;
    @Qualifier(value="eisService")
    @Autowired
    private EISServeable eisService;
    private static final Map<String, WorkflowTypes> WORKFLOWTYPE_CACHE = new ConcurrentHashMap<String, WorkflowTypes>();

    public List<T> getInboxItems(Long userId) {
        return this.fetchInboxItems(userId, this.eisService.getPositionsForUser(userId, new Date()).parallelStream().map(position -> position.getId()).collect(Collectors.toList()));
    }

    public List<T> getInboxDraftItems(Long userId) {
        return this.fetchInboxDraftItems(userId, this.eisService.getPositionsForUser(userId, new Date()).parallelStream().map(position -> position.getId()).collect(Collectors.toList()));
    }

    public List<StateHistory> getWorkflowHistory(Long stateId) {
        return new LinkedList<StateHistory>(this.statePersistenceService.findById(stateId, false).getHistory());
    }

    public List<T> fetchInboxItems(String wfType, String myLinkId) {
        Optional<InboxRenderService<T>> inboxRenderService = this.getWorkflowTypeService(wfType);
        List<Object> stateAwares = new ArrayList();
        if (inboxRenderService.isPresent()) {
            stateAwares = inboxRenderService.get().getWorkflowItems(myLinkId);
        }
        return stateAwares;
    }

    public List<T> fetchInboxItems(Long userId, List<Long> owners) {
        ArrayList<T> assignedWFItems = new ArrayList<T>();
        if (!owners.isEmpty()) {
            List<String> wfTypes = this.getAssignedWorkflowTypes(owners);
            for (String wfType : wfTypes) {
                Optional<InboxRenderService<T>> wfTypeService = this.getWorkflowTypeService(wfType);
                if (!wfTypeService.isPresent()) continue;
                assignedWFItems.addAll(wfTypeService.get().getAssignedWorkflowItems(userId, owners));
            }
        }
        return assignedWFItems;
    }

    public List<T> fetchInboxDraftItems(Long userId, List<Long> owners) {
        ArrayList<T> draftWfItems = new ArrayList<T>();
        if (!owners.isEmpty()) {
            List<String> wfTypes = this.getAssignedWorkflowTypes(owners);
            for (String wfType : wfTypes) {
                Optional<InboxRenderService<T>> wfTypeService = this.getWorkflowTypeService(wfType);
                if (!wfTypeService.isPresent()) continue;
                draftWfItems.addAll(wfTypeService.get().getDraftWorkflowItems(userId, owners));
            }
        }
        return draftWfItems;
    }

    public WorkflowTypes getWorkflowType(String wfType) {
        WorkflowTypes workflowType = WORKFLOWTYPE_CACHE.get(wfType);
        if (workflowType == null && (workflowType = (WorkflowTypes)this.workflowTypePersistenceService.getSession().createCriteria(WorkflowTypes.class).add((Criterion)Restrictions.eq((String)"renderYN", (Object)InboxRenderService.RENDER_Y)).add((Criterion)Restrictions.eq((String)"type", (Object)wfType)).setProjection((Projection)Projections.projectionList().add((Projection)Projections.property((String)"type"), "type").add((Projection)Projections.property((String)"link"), "link").add((Projection)Projections.property((String)"displayName"), "displayName").add((Projection)Projections.property((String)"renderYN"), "renderYN").add((Projection)Projections.property((String)"groupYN"), "groupYN")).setReadOnly(true).setResultTransformer(Transformers.aliasToBean(WorkflowTypes.class)).uniqueResult()) != null) {
            WORKFLOWTYPE_CACHE.put(wfType, workflowType);
        }
        return workflowType;
    }

    public List<String> getAssignedWorkflowTypes(List<Long> owners) {
        return this.entityQueryService.findAllByNamedQuery("WORKFLOWTYPES", owners);
    }

    public Optional<InboxRenderService<T>> getWorkflowTypeService(String wfType) {
        InboxRenderService workflowTypeService = null;
        try {
            if (this.getWorkflowType(wfType) != null) {
                workflowTypeService = (InboxRenderService)this.applicationContext.getBean(wfType.concat("InboxRenderService"));
            }
        }
        catch (BeansException e) {
            LOG.warn("InboxRenderService bean for {} not found, have you defined {}InboxRenderService bean ?", (Object)wfType, (Object)wfType);
        }
        return Optional.ofNullable(workflowTypeService);
    }

    public List<T> getFilteredInboxItems(Long owner, Long userId, Long sender, String taskName, Date fromDate, Date toDate) {
        ArrayList<T> filteredWFItems = new ArrayList<T>();
        List<Object> wfTypes = null;
        if (taskName == null || "".equals(taskName.trim())) {
            wfTypes = this.getAssignedWorkflowTypes(Arrays.asList(owner));
        } else {
            wfTypes = new ArrayList();
            WorkflowTypes wfType = this.workflowTypePersistenceService.find("from org.egov.infstr.models.WorkflowTypes  where displayName=?", taskName);
            wfTypes.add(wfType.getType());
        }
        for (String string : wfTypes) {
            Optional<InboxRenderService<T>> wfTypeService = this.getWorkflowTypeService(string);
            if (!wfTypeService.isPresent()) continue;
            filteredWFItems.addAll(wfTypeService.get().getFilteredWorkflowItems(owner, userId, sender, fromDate, toDate));
        }
        return filteredWFItems;
    }

    public List<T> getWorkflowItems(Map<String, Object> criteria) {
        return this.getWorkflowTypeService(criteria.get("wfType").toString()).get().getWorkflowItems(criteria);
    }

    public String getNextAction(State state) {
        String nextAction = "";
        if (state.getNextAction() != null) {
            WorkflowAction workflowAction = (WorkflowAction)this.entityQueryService.findByNamedQuery("BY_NAME_AND_TYPE", state.getNextAction(), state.getType());
            nextAction = workflowAction == null ? state.getNextAction() : (workflowAction.getDescription() == null ? state.getNextAction() : workflowAction.getDescription());
        }
        return nextAction;
    }
}

