/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.inbox;

import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.inbox.InboxRenderService;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class DefaultInboxRenderServiceImpl<T extends StateAware>
implements InboxRenderService<T> {
    private final Class<T> stateAwareType;
    private final PersistenceService<T, Long> stateAwarePersistenceService;

    public DefaultInboxRenderServiceImpl(PersistenceService<T, Long> stateAwarePersistenceService) {
        this.stateAwarePersistenceService = stateAwarePersistenceService;
        this.stateAwareType = stateAwarePersistenceService.getType();
    }

    @Override
    public List<T> getAssignedWorkflowItems(Long userId, List<Long> owners) {
        return this.stateAwarePersistenceService.getSession().createCriteria(this.stateAwareType).setFetchMode("state", FetchMode.JOIN).createAlias("state", "state").setFlushMode(FlushMode.MANUAL).setReadOnly(true).setCacheable(true).add((Criterion)Restrictions.eq((String)"state.type", (Object)this.stateAwareType.getSimpleName())).add(Restrictions.in((String)"state.ownerPosition.id", owners)).add((Criterion)Restrictions.ne((String)"state.status", (Object)((Object)State.StateStatus.ENDED))).add(Restrictions.not((Criterion)Restrictions.conjunction().add((Criterion)Restrictions.eq((String)"state.status", (Object)((Object)State.StateStatus.STARTED))).add((Criterion)Restrictions.eq((String)"createdBy.id", (Object)userId)))).addOrder(Order.desc((String)"state.createdDate")).list();
    }

    @Override
    public List<T> getDraftWorkflowItems(Long userId, List<Long> owners) {
        return this.stateAwarePersistenceService.getSession().createCriteria(this.stateAwareType).setFetchMode("state", FetchMode.JOIN).createAlias("state", "state").setFlushMode(FlushMode.MANUAL).setReadOnly(true).setCacheable(true).add((Criterion)Restrictions.eq((String)"state.type", (Object)this.stateAwareType.getSimpleName())).add(Restrictions.in((String)"state.ownerPosition.id", owners)).add((Criterion)Restrictions.eq((String)"createdBy.id", (Object)userId)).add((Criterion)Restrictions.eq((String)"state.status", (Object)((Object)State.StateStatus.STARTED))).addOrder(Order.asc((String)"state.createdDate")).list();
    }

    @Override
    public List<T> getFilteredWorkflowItems(Long owner, Long userId, Long sender, Date fromDate, Date toDate) {
        boolean isToDtNtNull;
        this.stateAwarePersistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        StringBuilder query = new StringBuilder("from ");
        query.append(this.stateAwareType.getName()).append(" WF where WF.state.type=:wfType and WF.state.ownerPosition =:owner ").append(sender == 0L ? "" : "and WF.state.senderName=:sender ").append(" and WF.state.createdDate ");
        query.append(fromDate == null && toDate == null ? "IS NOT NULL " : " >= :fromDate and WF.state.createdDate <:toDate ");
        query.append("  and WF.state.value !=:end and not (WF.state.value =:newState and WF.createdBy =:userId) order by WF.state.createdDate DESC");
        Query qry = this.stateAwarePersistenceService.getSession().createQuery(query.toString());
        qry.setLong("owner", owner.longValue());
        qry.setString("wfType", this.stateAwareType.getSimpleName());
        if (sender != 0L) {
            qry.setLong("sender", sender.longValue());
        }
        Date[] dates = null;
        boolean isFrmDtNtNull = fromDate != null;
        boolean bl = isToDtNtNull = toDate != null;
        if (isFrmDtNtNull && isToDtNtNull) {
            dates = DateUtils.constructDateRange(fromDate, toDate);
        } else if (isFrmDtNtNull) {
            dates = DateUtils.constructDateRange(fromDate, fromDate);
        } else if (isToDtNtNull) {
            dates = DateUtils.constructDateRange(toDate, toDate);
        }
        if (isFrmDtNtNull || isToDtNtNull) {
            qry.setDate("fromDate", dates[0]);
            qry.setDate("toDate", dates[1]);
        }
        qry.setParameter("end", (Object)State.StateStatus.ENDED);
        qry.setParameter("newState", (Object)State.StateStatus.STARTED);
        qry.setLong("userId", userId.longValue());
        qry.setReadOnly(true);
        return qry.list();
    }

    @Override
    public List<T> getWorkflowItems(Map<String, Object> criteria) {
        this.stateAwarePersistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        StringBuilder queryString = new StringBuilder("from ");
        queryString.append(this.stateAwareType.getName()).append(" WF where WF.state.type =:wfType and WF.state.status !=:end and WF.state.status !=:new ");
        if (criteria.containsKey("owner")) {
            queryString.append("and WF.state.owner in (:owner) ");
        }
        if (criteria.containsKey("sender")) {
            queryString.append("and WF.state.previous.owner in (:sender) ");
        }
        if (criteria.containsKey("wfState")) {
            queryString.append("and WF.state.value =:wfState ");
        }
        if (criteria.containsKey("identifier")) {
            queryString.append("and WF.").append(criteria.get("searchField")).append(this.getOperator((String)criteria.get("searchOp"))).append(((String)criteria.get("searchOp")).equals("between") ? " :identifier and :identifier2 " : (criteria.get("searchOp").toString().equals("in") ? " (:identifier) " : " :identifier "));
        }
        if (criteria.containsKey("fromDate") || criteria.containsKey("toDate")) {
            queryString.append("and WF.state.createdDate >= :fromDate and WF.state.createdDate < :toDate ");
        } else {
            queryString.append("and WF.state.createdDate IS NOT NULL ");
        }
        Date[] dates = null;
        if (criteria.containsKey("fromDate") && criteria.containsKey("toDate")) {
            dates = DateUtils.constructDateRange((Date)criteria.get("fromDate"), (Date)criteria.get("toDate"));
        } else if (criteria.containsKey("fromDate")) {
            dates = DateUtils.constructDateRange((Date)criteria.get("fromDate"), (Date)criteria.get("fromDate"));
        } else if (criteria.containsKey("toDate")) {
            dates = DateUtils.constructDateRange((Date)criteria.get("toDate"), (Date)criteria.get("toDate"));
        }
        queryString.append("order by WF.state.createdDate DESC");
        Query query = this.stateAwarePersistenceService.getSession().createQuery(queryString.toString());
        query.setString("wfType", criteria.get("wfType").toString());
        query.setParameter("end", (Object)State.StateStatus.ENDED);
        query.setParameter("new", (Object)State.StateStatus.STARTED);
        if (criteria.containsKey("owner")) {
            query.setParameterList("owner", (Collection)((List)criteria.get("owner")));
        }
        if (criteria.containsKey("sender")) {
            query.setParameterList("sender", (Collection)((List)criteria.get("sender")));
        }
        if (criteria.containsKey("wfState")) {
            query.setString("wfState", criteria.get("wfState").toString());
        }
        if (criteria.containsKey("identifier")) {
            if (criteria.get("searchOp").toString().equals("equals")) {
                query.setString("identifier", criteria.get("identifier").toString());
            } else if (criteria.get("searchOp").toString().equals("contains")) {
                query.setString("identifier", "%" + criteria.get("identifier") + "%");
            } else if (criteria.get("searchOp").toString().equals("startsWith")) {
                query.setString("identifier", criteria.get("identifier") + "%");
            } else if (criteria.get("searchOp").toString().equals("endsWith")) {
                query.setString("identifier", "%" + criteria.get("identifier"));
            } else if (criteria.get("searchOp").toString().equals("between")) {
                String[] betweenVal = criteria.get("identifier").toString().split("and");
                try {
                    if (this.stateAwareType.getDeclaredField(criteria.get("searchField").toString()).getType() == Date.class) {
                        Date[] dateAry = DateUtils.constructDateRange(betweenVal[0].trim(), betweenVal[1].trim());
                        query.setDate("identifier", dateAry[0]);
                        query.setDate("identifier2", dateAry[1]);
                    } else {
                        query.setString("identifier", betweenVal[0]);
                        query.setString("identifier2", betweenVal[1]);
                    }
                }
                catch (ParseException e) {
                    throw new ApplicationRuntimeException("Invalid identifier date range entered", e);
                }
                catch (NoSuchFieldException e) {
                    throw new ApplicationRuntimeException("Invalid identifier rage entered", e);
                }
            }
        }
        if (criteria.containsKey("fromDate") || criteria.containsKey("toDate")) {
            query.setDate("fromDate", dates[0]);
            query.setDate("toDate", dates[1]);
        }
        query.setReadOnly(true);
        return query.list();
    }

    @Override
    public List<T> getWorkflowItems(String myLinkId) {
        StringBuilder queryStr = new StringBuilder(" FROM ");
        queryStr.append(this.stateAwareType.getName()).append(" WHERE id = :id ");
        Query query = this.stateAwarePersistenceService.getSession().createQuery(queryStr.toString());
        query.setLong("id", Long.valueOf(myLinkId).longValue());
        return query.list();
    }

    public Class<?> getWorkflowType() {
        return this.stateAwareType;
    }

    private String getOperator(String searchOpVal) {
        String operator = null;
        if ("equals".equals(searchOpVal)) {
            operator = " = ";
        } else if ("contains".equals(searchOpVal) || "startsWith".equals(searchOpVal) || "endsWith".equals(searchOpVal)) {
            operator = " like ";
        } else if ("between".equals(searchOpVal)) {
            operator = " between ";
        }
        return operator;
    }
}

