/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.entity;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.entity.contract.StateInfoBuilder;
import org.egov.pims.commons.Position;
import org.egov.search.domain.Searchable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;

@MappedSuperclass
@Searchable
public abstract class StateAware
extends AbstractAuditable {
    private static final long serialVersionUID = 5776408218810221246L;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="STATE_ID")
    private State state;

    public abstract String getStateDetails();

    public String myLinkId() {
        return ((Long)this.getId()).toString();
    }

    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    public State getState() {
        return this.state;
    }

    protected void setState(State state) {
        this.state = state;
    }

    public final State getCurrentState() {
        return this.state;
    }

    public final List<StateHistory> getStateHistory() {
        return this.state == null ? Collections.emptyList() : new LinkedList<StateHistory>(this.state.getHistory());
    }

    public final String getStateType() {
        return this.getClass().getSimpleName();
    }

    public final boolean stateIsNew() {
        return this.hasState() && this.getCurrentState().isNew();
    }

    public final boolean stateIsEnded() {
        return this.hasState() && this.getCurrentState().isEnded();
    }

    public final boolean stateInProgress() {
        return this.hasState() && this.getState().getStatus().equals((Object)State.StateStatus.STARTED) || this.getState().getStatus().equals((Object)State.StateStatus.INPROGRESS);
    }

    public final boolean hasState() {
        return this.getCurrentState() != null;
    }

    public final StateAware transition() {
        if (this.hasState()) {
            this.state.addStateHistory(new StateHistory(this.state));
            this.state.setStatus(State.StateStatus.INPROGRESS);
            this.resetState();
        }
        return this;
    }

    public final StateAware transition(boolean clone) {
        if (this.hasState() && clone) {
            this.state.addStateHistory(new StateHistory(this.state));
            this.state.setStatus(State.StateStatus.INPROGRESS);
        } else {
            this.transition();
        }
        return this;
    }

    public final StateAware start() {
        if (this.hasState()) {
            throw new ApplicationRuntimeException("Workflow already started state.");
        }
        this.state = new State();
        this.state.setType(this.getStateType());
        this.state.setStatus(State.StateStatus.STARTED);
        this.state.setValue("Created");
        this.state.setComments("Created");
        return this;
    }

    public final StateAware end() {
        if (this.stateIsEnded()) {
            throw new ApplicationRuntimeException("Workflow already ended state.");
        }
        this.state.setValue("Closed");
        this.state.setStatus(State.StateStatus.ENDED);
        this.state.setComments("Closed");
        return this;
    }

    public final StateAware reopen(boolean clone) {
        if (this.stateIsEnded()) {
            StateHistory stateHistory = new StateHistory(this.state);
            stateHistory.setValue("Reopened");
            this.state.setStatus(State.StateStatus.INPROGRESS);
            this.state.addStateHistory(stateHistory);
            if (!clone) {
                this.resetState();
            }
        } else {
            throw new ApplicationRuntimeException("Workflow not ended.");
        }
        return this;
    }

    public final StateAware reinitiateTransition() {
        if (this.state != null && !this.stateIsEnded()) {
            throw new ApplicationRuntimeException("Could not reinitiate Workflow, existing workflow not ended.");
        }
        this.state = null;
        return this;
    }

    public final StateAware withOwner(User owner) {
        this.state.setOwnerUser(owner);
        return this;
    }

    public final StateAware withOwner(Position owner) {
        this.state.setOwnerPosition(owner);
        return this;
    }

    public final StateAware withStateValue(String currentStateValue) {
        this.state.setValue(currentStateValue);
        return this;
    }

    public final StateAware withNextAction(String nextAction) {
        this.state.setNextAction(nextAction);
        return this;
    }

    public final StateAware withComments(String comments) {
        this.state.setComments(comments);
        return this;
    }

    public final StateAware withNatureOfTask(String natureOfTask) {
        this.state.setNatureOfTask(natureOfTask);
        return this;
    }

    public final StateAware withExtraInfo(String extraInfo) {
        this.state.setExtraInfo(extraInfo);
        return this;
    }

    public final StateAware withDateInfo(Date dateInfo) {
        this.state.setDateInfo(dateInfo);
        return this;
    }

    public final StateAware withExtraDateInfo(Date extraDateInfo) {
        this.state.setExtraDateInfo(extraDateInfo);
        return this;
    }

    public final StateAware withSenderName(String senderName) {
        this.state.setSenderName(senderName);
        return this;
    }

    private void resetState() {
        this.state.setComments("");
        this.state.setDateInfo(null);
        this.state.setExtraDateInfo(null);
        this.state.setExtraInfo("");
        this.state.setNextAction("");
        this.state.setValue("");
        this.state.setSenderName("");
        this.state.setNatureOfTask("");
        this.state.setOwnerUser(null);
        this.state.setOwnerPosition(null);
    }

    public static Comparator<? super StateAware> byCreatedDate() {
        return (stateAware_1, stateAware_2) -> {
            int returnVal = 1;
            if (stateAware_1 == null) {
                returnVal = stateAware_2 == null ? 0 : -1;
            } else if (stateAware_2 == null) {
                returnVal = 1;
            } else {
                Date second_date;
                Date first_date = stateAware_1.getState().getCreatedDate();
                if (first_date.after(second_date = stateAware_2.getState().getCreatedDate())) {
                    returnVal = -1;
                } else if (first_date.equals(second_date)) {
                    returnVal = 0;
                }
            }
            return returnVal;
        };
    }

    protected StateInfoBuilder buildStateInfo() {
        return new StateInfoBuilder().task(this.getState().getNatureOfTask()).itemDetails(this.getStateDetails()).status(this.getCurrentState().getStatus().name()).refDate(this.getCreatedDate()).sender(this.getState().getSenderName()).senderPhoneno(this.getState().getExtraInfo());
    }

    public String getStateInfoJson() {
        return this.buildStateInfo().toJson();
    }
}

