/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.struts.interceptors;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.struts.annotation.ValidationErrorPageExt;
import org.egov.infra.web.struts.annotation.ValidationErrorPageForward;

public class ValidationInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;

    public String intercept(ActionInvocation invocation) throws Exception {
        String form = "edit";
        Method actionMethod = null;
        Object action = invocation.getAction();
        boolean isInvokeAndForward = false;
        try {
            Method m;
            String method = invocation.getProxy().getMethod();
            if ("create".equals(method)) {
                form = "new";
            }
            if ((m = action.getClass().getMethod(method, new Class[0])).isAnnotationPresent(ValidationErrorPage.class)) {
                form = m.getAnnotation(ValidationErrorPage.class).value();
            } else if (m.isAnnotationPresent(ValidationErrorPageExt.class)) {
                ValidationErrorPageExt validationErrorPageExt = m.getAnnotation(ValidationErrorPageExt.class);
                form = validationErrorPageExt.action();
                if (validationErrorPageExt.makeCall()) {
                    actionMethod = action.getClass().getMethod(validationErrorPageExt.toMethod(), new Class[0]);
                }
            } else if (m.isAnnotationPresent(ValidationErrorPageForward.class)) {
                ValidationErrorPageForward forwarder = m.getAnnotation(ValidationErrorPageForward.class);
                actionMethod = action.getClass().getDeclaredMethod(forwarder.forwarderMethod(), new Class[0]);
                isInvokeAndForward = true;
            }
            ValidationAware validationAwareAction = (ValidationAware)invocation.getAction();
            if (validationAwareAction.hasErrors()) {
                if (isInvokeAndForward) {
                    return (String)actionMethod.invoke(action, new Object[0]);
                }
                this.invokeActionMethod(actionMethod, action);
                return form;
            }
            return invocation.invoke();
        }
        catch (ValidationException e) {
            if (BaseFormAction.class.isAssignableFrom(invocation.getAction().getClass())) {
                this.transformValidationErrors(invocation, e);
                if (isInvokeAndForward) {
                    return (String)actionMethod.invoke(action, new Object[0]);
                }
                this.invokeActionMethod(actionMethod, action);
                return form;
            }
            throw e;
        }
    }

    private void invokeActionMethod(Method actionMethod, Object action) throws IllegalAccessException, InvocationTargetException, RuntimeException {
        if (actionMethod != null) {
            actionMethod.setAccessible(true);
            actionMethod.invoke(action, new Object[0]);
        }
    }

    private void transformValidationErrors(ActionInvocation invocation, ValidationException e) {
        BaseFormAction action = (BaseFormAction)((Object)invocation.getAction());
        List<ValidationError> errors = e.getErrors();
        for (ValidationError error : errors) {
            if (error.getArgs() == null || error.getArgs().length == 0) {
                action.addFieldError("model." + error.getKey(), action.getText(error.getMessage(), error.getMessage()));
                continue;
            }
            action.addFieldError("model." + error.getKey(), action.getText(error.getMessage(), error.getMessage(), error.getArgs()));
        }
    }
}

