/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.validation;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.properties.ApplicationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="validatorUtils")
public class ValidatorUtils {
    private static Pattern PASSWORD_PATTERN;

    @Autowired
    public ValidatorUtils(ApplicationProperties applicationProperties) {
        String passwordStrength = applicationProperties.passwordStrength();
        PASSWORD_PATTERN = "HIGH".equals(passwordStrength) ? Pattern.compile("(?=^.{8,32}$)(?=.*\\d)(?!.*[&<>#%\\'\\\"\\\\\\/])(?!.*\\s)(?=.*[A-Z])(?=.*[a-z]).*$") : ("MEDIUM".equals(passwordStrength) ? Pattern.compile("(?=^.{8,32}$)(?=.*\\d)(?!.*\\s)(?=.*[A-Z])(?=.*[a-z]).*$") : Pattern.compile("(?=^.{4,32}$)(?!.*\\s)(?=.*\\d)(?=.*[A-Z])(?=.*[a-z]).*$"));
    }

    public boolean isValidPassword(String pwd) {
        return StringUtils.isNotBlank((CharSequence)pwd) && PASSWORD_PATTERN.matcher(pwd).find();
    }
}

