/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.security.token.service;

import java.util.Date;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.security.token.entity.Token;
import org.egov.infra.security.token.repository.TokenRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TokenService {
    private static final long DEFAULT_ALLOWED_TOKEN_AGE_SECS = 300L;
    private static final Logger LOGGER = Logger.getLogger(TokenService.class);
    private final TokenRepository tokenRepository;
    @Autowired
    private CityService cityService;

    @Autowired
    public TokenService(TokenRepository tokenRepository) {
        this.tokenRepository = tokenRepository;
    }

    public Token findByTokenNumber(String tokenNumber) {
        return this.tokenRepository.findByTokenNumber(tokenNumber);
    }

    public Token findByTokenNumberandService(String tokenNumber, String service) {
        return this.tokenRepository.findByTokenNumberAndService(tokenNumber, service);
    }

    @Transactional
    public Token generate() {
        Token token = this.generate(300L, null, null);
        return token;
    }

    @Transactional
    public Token generate(long ttlSec) {
        Token token = this.createToken(ttlSec, null, null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Generated token: " + token));
        }
        return token;
    }

    @Transactional
    public Token generate(long ttlSec, String service) {
        return this.generate(ttlSec, null, service);
    }

    @Transactional
    public Token generate(String tokenIdentity, String service) {
        return this.generate(300L, tokenIdentity, service);
    }

    @Transactional
    public Token generate(long ttlSec, String tokenIdentity, String service) {
        return this.createToken(ttlSec, tokenIdentity, service);
    }

    @Transactional
    private Token createToken(long ttlSecs, String tokenIdentity, String service) {
        String uUID = UUID.randomUUID().toString();
        Token token = new Token();
        token.setTokenNumber(uUID);
        token.setTtlSecs(ttlSecs);
        token.setCreatedDate(new Date());
        token.setService(service);
        token.setTokenIdentity(tokenIdentity);
        return (Token)this.tokenRepository.save(token);
    }

    @Transactional
    public void redeem(String tokenNumber, String service) {
        Token token = this.tokenRepository.findByTokenNumberAndService(tokenNumber, service);
        if (token == null) {
            throw new ApplicationRuntimeException("Token " + tokenNumber + " does not exist!");
        }
        this.redeem(token);
    }

    @Transactional
    public void redeem(Token token) {
        this.checkIsRedeemable(token);
        this.tokenRepository.delete(token);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Redeemed token: " + token.getTokenNumber()));
        }
    }

    public Token checkIsRedeemable(Token token) {
        Date tokenDate = token.getCreatedDate();
        long tokenTTL = token.getTtlSecs() * 1000L;
        long now = new Date().getTime();
        if (now - tokenDate.getTime() > tokenTTL) {
            throw new ApplicationRuntimeException("Token " + token.getTokenNumber() + " has expired!");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("checkIsRedeemable() for token " + token.getTokenNumber() + " passed, token created time was " + tokenDate));
        }
        return token;
    }

    public Token checkIsRedeemable(String tokenNumber, String service) {
        Token token = this.findByTokenNumberandService(tokenNumber, service);
        if (token == null) {
            throw new ApplicationRuntimeException("Token " + tokenNumber + " for service " + service + " does not exist!");
        }
        return this.checkIsRedeemable(token);
    }
}

