/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.scheduler.quartz;

import java.util.Map;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.quartz.JobDataMap;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.impl.SchedulerRepository;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class QuartzJobAwareBeanFactory
extends SpringBeanJobFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzJobAwareBeanFactory.class);
    private static final String APP_CTX_NAME_PREFIX = "applicationQuartzContext-";
    private static final String SCHEDULER_NAME_SUFFIX = "-scheduler";
    private String[] ignoredUnknownProperties;

    public void setIgnoredUnknownProperties(String[] ignoredUnknownProperties) {
        super.setIgnoredUnknownProperties(ignoredUnknownProperties);
        this.ignoredUnknownProperties = ignoredUnknownProperties;
    }

    protected Object createJobInstance(TriggerFiredBundle bundle) {
        try {
            JobDataMap jobDataMap = bundle.getJobDetail().getJobDataMap();
            SchedulerContext schedulerContext = SchedulerRepository.getInstance().lookup(jobDataMap.getString("moduleName") + SCHEDULER_NAME_SUFFIX).getContext();
            XmlWebApplicationContext ctx = (XmlWebApplicationContext)schedulerContext.get((Object)(APP_CTX_NAME_PREFIX + jobDataMap.getString("moduleName")));
            Object job = ctx.getBean(jobDataMap.getString("jobBeanName"), bundle.getJobDetail().getJobClass());
            BeanWrapperImpl bw = new BeanWrapperImpl(job);
            if (this.isEligibleForPropertyPopulation(bw.getWrappedInstance())) {
                MutablePropertyValues pvs = new MutablePropertyValues();
                if (schedulerContext != null) {
                    pvs.addPropertyValues((Map)schedulerContext);
                }
                pvs.addPropertyValues((Map)jobDataMap);
                pvs.addPropertyValues((Map)bundle.getTrigger().getJobDataMap());
                if (this.ignoredUnknownProperties != null) {
                    for (String ignoredUnknownPropertie : this.ignoredUnknownProperties) {
                        String propName = ignoredUnknownPropertie;
                        if (!pvs.contains(propName) || bw.isWritableProperty(propName)) continue;
                        pvs.removePropertyValue(propName);
                    }
                    bw.setPropertyValues((PropertyValues)pvs);
                } else {
                    bw.setPropertyValues((PropertyValues)pvs, true);
                }
            }
            return bw.getWrappedInstance();
        }
        catch (BeansException e) {
            LOGGER.error("Error occurred while initializing Scheduler Job Beans, cause : ", (Throwable)e);
            throw new ApplicationRuntimeException("Error occurred while initializing Scheduler Job Beans, cause : ", e);
        }
        catch (SchedulerException e) {
            LOGGER.error("Error occurred while initializing Scheduler Job Beans, cause : ", (Throwable)e);
            throw new ApplicationRuntimeException("Error occurred while initializing Scheduler, cause : ", e);
        }
    }
}

