/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.reporting.viewer;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class ReportViewer
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportViewer.class);
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)((Object)this), (ServletContext)config.getServletContext());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String reportId = req.getParameter("reportId");
        try {
            ReportOutput reportOutput = this.reportViewerUtil.getReportOutputFormCache(reportId);
            this.renderReport(resp, reportOutput);
        }
        catch (Exception e) {
            LOGGER.error("Invalid report id [" + reportId + "]", (Throwable)e);
            throw new ApplicationRuntimeException("Error occurred while generating report", e);
        }
        finally {
            this.reportViewerUtil.removeReportOutputFromCache(reportId);
        }
    }

    private void renderReport(HttpServletResponse resp, ReportOutput reportOutput) {
        if (reportOutput == null) {
            this.renderHtml(resp, "<html><body><b>ERROR: Report output not available!</b></body></html>");
            return;
        }
        ReportConstants.FileFormat reportFormat = reportOutput.getReportFormat();
        if (reportFormat == null) {
            this.renderHtml(resp, "<html><body><b>ERROR: Report format not available!</b></body></html>");
            return;
        }
        byte[] reportData = reportOutput.getReportOutputData();
        if (reportData == null) {
            this.renderHtml(resp, "<html><body><b>ERROR: Report data not available!</b></body></html>");
            return;
        }
        this.renderReport(resp, reportData, reportFormat);
    }

    private void renderHtml(HttpServletResponse resp, String htmContent) {
        this.renderReport(resp, htmContent.getBytes(), ReportConstants.FileFormat.HTM);
    }

    private void renderReport(HttpServletResponse resp, byte[] reportData, ReportConstants.FileFormat reportFormat) {
        try (BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)resp.getOutputStream());){
            resp.setHeader("Content-disposition", ReportViewerUtil.getContentDisposition(reportFormat));
            resp.setContentType(ReportViewerUtil.getContentType(reportFormat));
            resp.setContentLength(reportData.length);
            outputStream.write(reportData);
        }
        catch (Exception e) {
            String errMsg = "Exception in rendering report with format [" + (Object)((Object)reportFormat) + "]!";
            LOGGER.error(errMsg, (Throwable)e);
            throw new ApplicationRuntimeException(errMsg, e);
        }
    }
}

