/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.persistence.validator;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.validator.annotation.CompareDates;

public class CompareDatesValidator
implements ConstraintValidator<CompareDates, Date> {
    private CompareDates compareDates;

    public void initialize(CompareDates compareDates) {
        this.compareDates = compareDates;
    }

    public boolean isValid(Date date, ConstraintValidatorContext arg1) {
        if (this.compareDates.fromDate() == null || this.compareDates.toDate() == null || this.compareDates.dateFormat() == null) {
            return false;
        }
        return this.dateValidation(date, this.compareDates.fromDate(), this.compareDates.toDate());
    }

    private boolean dateValidation(Date date, String field1, String field2) {
        Date fromDate = this.getValue(date, field1);
        Date toDate = this.getValue(date, field2);
        if (fromDate == null || toDate == null) {
            return false;
        }
        return fromDate.before(toDate);
    }

    private Date getValue(Date target, String field) {
        try {
            PropertyDescriptor[] props;
            BeanInfo info = Introspector.getBeanInfo(target.getClass());
            for (PropertyDescriptor propertyDescriptor : props = info.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().equals(field)) continue;
                return (Date)propertyDescriptor.getReadMethod().invoke((Object)target, new Object[0]);
            }
            return null;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e.getMessage(), e);
        }
    }
}

