/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.gis.service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.gis.model.GeoKmlInfo;
import org.egov.infra.gis.model.GeoLocation;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoLocationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoLocationService.class);

    public static String getMarkerDesc(GeoLocation geoLocation) {
        StringBuffer markerDesc = new StringBuffer(1000);
        markerDesc.append(null != geoLocation.getInfo1() ? "<tr><td><b>" + geoLocation.getInfo1().substring(0, geoLocation.getInfo1().indexOf("=")) + "</b></td><td>" + geoLocation.getInfo1().substring(geoLocation.getInfo1().indexOf("=") + 1) + "</td></tr>" : "").append(null != geoLocation.getInfo2() ? "<tr><td><b>" + geoLocation.getInfo2().substring(0, geoLocation.getInfo2().indexOf("=")) + "</b></td><td>" + geoLocation.getInfo2().substring(geoLocation.getInfo2().indexOf("=") + 1) + "</td></tr>" : "").append(null != geoLocation.getInfo3() ? "<tr><td><b>" + geoLocation.getInfo3().substring(0, geoLocation.getInfo3().indexOf("=")) + "</b></td><td>" + geoLocation.getInfo3().substring(geoLocation.getInfo3().indexOf("=") + 1) + "</td></tr>" : "").append(null != geoLocation.getInfo1() ? "<tr><td><b>" + geoLocation.getInfo4().substring(0, geoLocation.getInfo4().indexOf("=")) + "</b></td><td>" + geoLocation.getInfo4().substring(geoLocation.getInfo4().indexOf("=") + 1) + "</td></tr>" : "");
        return markerDesc.toString();
    }

    public static String getMarkerOption(GeoLocation geoLoc) {
        StringBuffer markerOption = new StringBuffer(1000);
        markerOption.append("{").append("position: new google.maps.LatLng('").append(geoLoc.getGeoLatLong().getLatitude()).append("','").append(geoLoc.getGeoLatLong().getLongitude()).append("'), map: map");
        Map<String, Object> markerOptData = geoLoc.getMarkerOptionData();
        if (null != markerOptData && markerOptData.size() > 0) {
            for (Map.Entry<String, Object> entry : markerOptData.entrySet()) {
                String value = entry.getValue().toString();
                if (entry.getKey().equalsIgnoreCase("icon")) {
                    value = "http://www.google.com/mapfiles/ms/icons/" + value + "-dot.png";
                }
                markerOption.append(",").append(entry.getKey()).append(":'").append(value).append("'");
            }
        }
        markerOption.append("};");
        return markerOption.toString();
    }

    private static String putKmlDataToCache(GeoKmlInfo geoKmlInfo) {
        HashMap<String, GeoKmlInfo> cacheDataModelMap = new HashMap<String, GeoKmlInfo>();
        String kmlDataModelKey = UUID.randomUUID().toString().substring(0, 10);
        cacheDataModelMap.put(kmlDataModelKey, geoKmlInfo);
        return kmlDataModelKey;
    }

    public static GeoKmlInfo getKmlDataFromCache(String kmlDataModelKey) {
        GeoKmlInfo geoKmlInfo = null;
        if (null == geoKmlInfo) {
            LOGGER.error("Could not able to retrive kml data  from cache for the key " + kmlDataModelKey);
            throw new ApplicationRuntimeException("Could not able to retrive kml data  from cache for the key " + kmlDataModelKey);
        }
        return geoKmlInfo;
    }

    public static void setKmlDataToCacheAndRequest(Map<String, BigDecimal> wardWiseData, Map<Integer, String> colorCodes, String kmlPath, HttpServletRequest request) {
        LOGGER.debug("GeoLocationService | setKmlDataToCacheAndRequest | Start");
        int totalNoOfColors = colorCodes.size();
        BigDecimal wardDataMinAmount = Collections.min(wardWiseData.values()).setScale(0, 4);
        BigDecimal wardDataMaxAmount = Collections.max(wardWiseData.values()).setScale(0, 4);
        if (wardDataMaxAmount.subtract(wardDataMinAmount).compareTo(BigDecimal.valueOf(totalNoOfColors)) == -1) {
            throw new ValidationException(Arrays.asList(new ValidationError("colorrange", "no of colors supplied is more than the range of data in the wards")));
        }
        BigDecimal rangeSize = GeoLocationService.getRangeSize(wardDataMinAmount, wardDataMaxAmount, totalNoOfColors);
        GeoKmlInfo geoKmlInfo = new GeoKmlInfo();
        HashMap<String, String> wardWiseKmlColorStyle = new HashMap<String, String>();
        for (Map.Entry<String, BigDecimal> entry : wardWiseData.entrySet()) {
            wardWiseKmlColorStyle.put("style" + entry.getKey(), GeoLocationService.getStyleColorName(entry.getValue(), wardDataMinAmount, totalNoOfColors, rangeSize));
        }
        geoKmlInfo.setWardWiseColor(wardWiseKmlColorStyle);
        geoKmlInfo.setColorCodes(GeoLocationService.convertToKmlColor(colorCodes));
        request.setAttribute("kmlDataModelKey", (Object)GeoLocationService.putKmlDataToCache(geoKmlInfo));
        request.setAttribute("colorCodeAndRange", GeoLocationService.getColorRange(wardDataMinAmount, wardDataMaxAmount, rangeSize, colorCodes));
        if (null != kmlPath && StringUtils.isNotEmpty((String)kmlPath)) {
            request.setAttribute("kmlurlpath", (Object)kmlPath);
        }
        LOGGER.debug("GeoLocationService | setKmlDataToCacheAndRequest | End");
    }

    private static Map<String, String> convertToKmlColor(Map<Integer, String> colorMap) {
        HashMap<String, String> kmlColorConvertedMap = new HashMap<String, String>();
        for (Map.Entry<Integer, String> entry : colorMap.entrySet()) {
            String color = entry.getValue();
            color = "FF" + color.substring(4, 6) + color.substring(2, 4) + color.substring(0, 2);
            kmlColorConvertedMap.put("color" + entry.getKey(), color);
        }
        return kmlColorConvertedMap;
    }

    private static Map<String, String> getColorRange(BigDecimal wardDataMinAmount, BigDecimal wardDataMaxAmount, BigDecimal rangeSize, Map<Integer, String> colorCodes) {
        int totalNoOfColors = colorCodes.size();
        LinkedHashMap<String, String> colorRangeMap = new LinkedHashMap<String, String>();
        BigDecimal rangeStartVal = wardDataMinAmount;
        BigDecimal rangeEndVal = wardDataMinAmount;
        for (int i = 0; i < totalNoOfColors; ++i) {
            BigDecimal nextRangeStartVal;
            rangeEndVal = totalNoOfColors != i + 1 ? rangeStartVal.add(rangeSize).subtract(BigDecimal.ONE) : wardDataMaxAmount;
            String colorRange = rangeStartVal + " - " + rangeEndVal;
            colorRangeMap.put(colorCodes.get(totalNoOfColors - i), colorRange);
            rangeStartVal = nextRangeStartVal = rangeEndVal.add(BigDecimal.ONE);
        }
        return colorRangeMap;
    }

    private static String getStyleColorName(BigDecimal wardWiseNos, BigDecimal wardDataMinAmount, Integer totalNoOfColors, BigDecimal rangeSize) {
        return "#color" + BigDecimal.valueOf(totalNoOfColors.intValue()).subtract(wardWiseNos.subtract(wardDataMinAmount).subtract(BigDecimal.ONE).divide(rangeSize, 0, 1));
    }

    private static BigDecimal getRangeSize(BigDecimal wardDataMinAmount, BigDecimal wardDataMaxAmount, int totalNoOfColors) {
        BigDecimal rangeSize = wardDataMaxAmount.subtract(wardDataMinAmount).divide(BigDecimal.valueOf(totalNoOfColors), 4);
        return rangeSize;
    }
}

