/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.properties;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration
@PropertySource(value={"classpath:config/application-config.properties", "classpath:config/egov-erp-${user.name}.properties", "classpath:config/application-config-${client.id}.properties", "classpath:config/egov-erp-override.properties"}, ignoreResourceNotFound=true)
@Order(value=0)
public class ApplicationProperties {
    @Autowired
    private Environment environment;

    public String fileStoreBaseDir() {
        return this.environment.getProperty("filestore.base.dir");
    }

    public String filestoreServiceBeanName() {
        return this.environment.getProperty("filestoreservice.beanname");
    }

    public String defaultDatePattern() {
        return this.environment.getProperty("default.date.pattern");
    }

    public Integer mailPort() {
        return (Integer)this.environment.getProperty("mail.port", Integer.class);
    }

    public String mailHost() {
        return this.environment.getProperty("mail.host");
    }

    public String mailProtocol() {
        return this.environment.getProperty("mail.protocol");
    }

    public String mailSenderUsername() {
        return this.environment.getProperty("mail.sender.username");
    }

    public String mailSenderPassword() {
        return this.environment.getProperty("mail.sender.password");
    }

    public String mailSMTPSAuth() {
        return this.environment.getProperty("mail.smtps.auth");
    }

    public String mailStartTLSEnabled() {
        return this.environment.getProperty("mail.smtps.starttls.enable");
    }

    public String mailSMTPSDebug() {
        return this.environment.getProperty("mail.smtps.debug");
    }

    public String smsProviderURL() {
        return this.environment.getProperty("sms.provider.url");
    }

    public String smsSenderUsername() {
        return this.environment.getProperty("sms.sender.username");
    }

    public String smsSenderPassword() {
        return this.environment.getProperty("sms.sender.password");
    }

    public String smsSender() {
        return this.environment.getProperty("sms.sender");
    }

    public String[] commonMessageFiles() {
        return this.environment.getProperty("common.properties.files").split(",");
    }

    public boolean devMode() {
        return (Boolean)this.environment.getProperty("dev.mode", Boolean.class);
    }

    public boolean emailEnabled() {
        return (Boolean)this.environment.getProperty("mail.enabled", Boolean.class);
    }

    public boolean smsEnabled() {
        return (Boolean)this.environment.getProperty("sms.enabled", Boolean.class);
    }

    public Integer userPasswordExpiryInDays() {
        return (Integer)this.environment.getProperty("user.pwd.expiry.days", Integer.class);
    }

    public List<String> smsErrorCodes() {
        return Arrays.asList(this.environment.getProperty("sms.error.codes").split(","));
    }

    public String smsResponseMessageForCode(String errorCode) {
        return this.environment.getProperty(errorCode, "No Message");
    }

    public boolean multiTenancyEnabled() {
        return (Boolean)this.environment.getProperty("multitenancy.enabled", Boolean.class);
    }

    public String getProperty(String propKey) {
        return this.environment.getProperty(propKey, "");
    }

    public <T> T getProperty(String propKey, Class<T> type) {
        return (T)this.environment.getProperty(propKey, type);
    }

    public String appVersion() {
        return this.environment.getProperty("app.version", "");
    }

    public String appBuildNo() {
        return this.environment.getProperty("app.build.no", "");
    }

    public String appCoreBuildNo() {
        return this.environment.getProperty("app.core.build.no", "");
    }

    public String issueReportingUrl() {
        return this.environment.getProperty("issue.report.url", "");
    }

    public List<String> portalEnabledFeatures() {
        return Arrays.asList(this.environment.getProperty("portal.feature.enabled").split(","));
    }

    public boolean statewideMigrationRequired() {
        return (Boolean)this.environment.getProperty("statewide.migration.required", Boolean.class, (Object)Boolean.FALSE);
    }

    public Integer getBatchUpdateSize() {
        return (Integer)this.environment.getProperty("hibernate.jdbc.batch_size", Integer.class);
    }

    public String passwordStrength() {
        return this.environment.getProperty("user.pwd.strength");
    }

    public boolean sentinelEnabled() {
        return (Boolean)this.environment.getProperty("redis.enable.sentinel", Boolean.class);
    }

    public List<String> sentinelHosts() {
        return Arrays.asList(this.environment.getProperty("redis.sentinel.hosts").split(","));
    }

    public String sentinelMasterName() {
        return this.environment.getProperty("redis.sentinel.master.name");
    }

    public boolean usingEmbeddedRedis() {
        return (Boolean)this.environment.getProperty("redis.enable.embedded", Boolean.class);
    }

    public String redisHost() {
        return this.environment.getProperty("redis.host.name");
    }

    public int redisPort() {
        return (Integer)this.environment.getProperty("redis.host.port", Integer.class);
    }
}

