/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.persistence;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.jndi.JndiObjectFactoryBean;

@Configuration
@Profile(value={"production"})
@PropertySource(value={"classpath:config/persistence-config.properties"})
public class DatasourceConfiguration {
    @Autowired
    private Environment env;

    @Bean
    public JndiObjectFactoryBean dataSource() throws IllegalArgumentException {
        JndiObjectFactoryBean dataSource = new JndiObjectFactoryBean();
        dataSource.setExpectedType(DataSource.class);
        dataSource.setJndiName(this.env.getProperty("default.jdbc.jndi.dataSource"));
        return dataSource;
    }
}

