/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.repository.RoleRepository;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class RoleService {
    private final RoleRepository roleRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public RoleService(RoleRepository roleRepository) {
        this.roleRepository = roleRepository;
    }

    @Transactional
    public void createRole(Role role) {
        this.roleRepository.saveAndFlush(role);
    }

    @Transactional
    public void update(Role role) {
        this.roleRepository.saveAndFlush(role);
    }

    @Transactional
    public void remove(Role role) {
        this.roleRepository.delete(role);
    }

    public List<Role> getAllRoles() {
        return this.roleRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public Role getRoleById(Long roleID) {
        return (Role)this.roleRepository.findOne(roleID);
    }

    public Role getRoleByName(String name) {
        return this.roleRepository.findByName(name);
    }

    public List<Role> getRolesByNameLike(String name) {
        return this.roleRepository.findByNameContainingIgnoreCase(name);
    }

    public Role load(Long id) {
        return (Role)((Session)this.entityManager.unwrap(Session.class)).load(Role.class, (Serializable)id);
    }
}

