/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.egov.infra.admin.common.entity.MenuLink;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.repository.ModuleRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ModuleService {
    @Autowired
    private ModuleRepository moduleRepository;

    public Module getModuleByName(String moduleName) {
        return this.moduleRepository.findByName(moduleName);
    }

    public List<MenuLink> getMenuLinksForRoles(Set<Role> roles) {
        List elements = this.moduleRepository.fetchModulesForRoles(roles);
        ArrayList<MenuLink> menuLinks = new ArrayList<MenuLink>();
        elements.forEach(element -> {
            MenuLink menuLink = new MenuLink();
            menuLink.setName(element[0] != null ? element[0].toString() : "");
            menuLink.setUrl(element[1] != null ? element[1].toString() : "");
            menuLink.setDisplayName(element[2] != null ? element[2].toString() : "");
            menuLink.setId(Long.valueOf(element[3] != null ? element[3].toString() : "0"));
            menuLinks.add(menuLink);
        });
        return menuLinks;
    }

    public List<MenuLink> getMenuLinksByParentModuleId(Long parentId, Long userId) {
        List elements = this.moduleRepository.fetchModulesByParentModuleId(parentId, userId);
        ArrayList<MenuLink> menuLinks = new ArrayList<MenuLink>();
        elements.forEach(element -> {
            MenuLink menuLink = new MenuLink();
            menuLink.setId(Long.valueOf(element[0] != null ? element[0].toString() : "0"));
            menuLink.setName(element[1] != null ? element[1].toString() : "");
            menuLink.setUrl(element[2] != null ? element[2].toString() : "");
            menuLink.setEnabled(element[3] != null && element[3].toString().equals("A"));
            menuLink.setContextRoot(element[4] != null ? element[4].toString() : "");
            menuLinks.add(menuLink);
        });
        return menuLinks;
    }

    public List<MenuLink> getUserFavouritesMenuLinks(Long userId) {
        List elements = this.moduleRepository.fetchUserFavourateModules(userId);
        ArrayList<MenuLink> menuLinks = new ArrayList<MenuLink>();
        elements.forEach(element -> {
            MenuLink menuLink = new MenuLink();
            menuLink.setId(Long.valueOf(element[0] != null ? element[0].toString() : "0"));
            menuLink.setName(element[1] != null ? element[1].toString() : "");
            menuLink.setUrl(element[2] != null && element[3] != null ? element[2].toString() + element[3] : "");
            menuLinks.add(menuLink);
        });
        return menuLinks;
    }
}

