/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.List;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.CrossHierarchy;
import org.egov.infra.admin.master.repository.CrossHierarchyRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CrossHierarchyService {
    private final CrossHierarchyRepository crossHierarchyRepository;

    @Autowired
    public CrossHierarchyService(CrossHierarchyRepository crossHierarchyRepository) {
        this.crossHierarchyRepository = crossHierarchyRepository;
    }

    public List<Boundary> getCrossHierarchyChildrens(Boundary boundary, BoundaryType boundaryType) {
        return this.crossHierarchyRepository.findByParentAndChildBoundaryType(boundary, boundaryType);
    }

    public List<CrossHierarchy> getChildBoundaryNameAndBndryTypeAndHierarchyType(String boundaryTypeName, String hierarchyTypeName, String parenthierarchyTypeName, String name) {
        return this.crossHierarchyRepository.findActiveBoundariesByNameAndBndryTypeNameAndHierarchyTypeName(boundaryTypeName, hierarchyTypeName, parenthierarchyTypeName, name);
    }

    public List<Boundary> getChildBoundariesNameAndBndryTypeAndHierarchyType(String boundaryTypeName, String hierarchyTypeName) {
        return this.crossHierarchyRepository.findChildBoundariesNameAndBndryTypeAndHierarchyType(boundaryTypeName, hierarchyTypeName);
    }

    public List<Boundary> getParentBoundaryByChildBoundaryAndParentBoundaryType(Long childId, Long parentTypeId) {
        return this.crossHierarchyRepository.findParentBoundaryByChildBoundaryAndParentBoundaryType(childId, parentTypeId);
    }

    public List<Boundary> getActiveChildBoundariesByBoundaryId(Long id) {
        return this.crossHierarchyRepository.findActiveBoundariesById(id);
    }

    public CrossHierarchy findById(Long id) {
        return (CrossHierarchy)this.crossHierarchyRepository.findOne(id);
    }

    public List<CrossHierarchy> findAllByBoundaryTypes(BoundaryType parentType, BoundaryType childType) {
        return this.crossHierarchyRepository.findByParentTypeAndChildType(parentType, childType);
    }

    public List<Boundary> findChildBoundariesByParentBoundary(String boundaryTypeName, String hierarchyTypeName, String parentBoundary) {
        return this.crossHierarchyRepository.findChildBoundariesByParentBoundary(boundaryTypeName, hierarchyTypeName, parentBoundary);
    }
}

