/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.List;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.repository.BoundaryTypeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BoundaryTypeService {
    private final BoundaryTypeRepository boundaryTypeRepository;

    @Autowired
    public BoundaryTypeService(BoundaryTypeRepository boundaryTypeRepository) {
        this.boundaryTypeRepository = boundaryTypeRepository;
    }

    @Transactional
    public void createBoundaryType(BoundaryType boundaryType) {
        this.boundaryTypeRepository.save(boundaryType);
    }

    @Transactional
    public void updateBoundaryType(BoundaryType boundaryType) {
        this.boundaryTypeRepository.save(boundaryType);
    }

    public BoundaryType getBoundaryTypeById(Long id) {
        return (BoundaryType)this.boundaryTypeRepository.findOne(id);
    }

    public BoundaryType getBoundaryTypeByName(String name) {
        return this.boundaryTypeRepository.findByName(name);
    }

    public List<BoundaryType> getAllBoundaryTypes() {
        return this.boundaryTypeRepository.findAll();
    }

    public BoundaryType getBoundaryTypeByHierarchyTypeNameAndLevel(String name, Long hierarchyLevel) {
        return this.boundaryTypeRepository.findByHierarchyTypeNameAndLevel(name, hierarchyLevel);
    }

    public List<BoundaryType> getAllBoundarTypesByHierarchyTypeId(Long hierarchyTypeId) {
        return this.boundaryTypeRepository.findByHierarchyTypeId(hierarchyTypeId);
    }

    public BoundaryType getBoundaryTypeByParent(Long parentId) {
        return this.boundaryTypeRepository.findByParent(parentId);
    }

    public BoundaryType getBoundaryTypeByIdAndHierarchyType(Long id, Long hierarchyTypeId) {
        return this.boundaryTypeRepository.findByIdAndHierarchy(id, hierarchyTypeId);
    }

    public BoundaryType setHierarchyLevel(BoundaryType boundaryType, String mode) {
        if (mode.equalsIgnoreCase("create")) {
            boundaryType.setHierarchy(1L);
        } else {
            Long parentBoundaryTypeId = boundaryType.getParent().getId();
            Long childHierarchy = 0L;
            Long parentHierarchy = boundaryType.getParent().getHierarchy();
            if (parentBoundaryTypeId != null) {
                childHierarchy = parentHierarchy = Long.valueOf(parentHierarchy + 1L);
            }
            boundaryType.setHierarchy(childHierarchy);
        }
        return boundaryType;
    }

    public BoundaryType getBoundaryTypeByNameAndHierarchyType(String name, HierarchyType hierarchyType) {
        return this.boundaryTypeRepository.findByNameAndHierarchyType(name, hierarchyType);
    }

    public BoundaryType getBoundaryTypeByNameAndHierarchyTypeName(String boundaryTypename, String hierarchyTypeName) {
        return this.boundaryTypeRepository.findByNameAndHierarchyTypeName(boundaryTypename, hierarchyTypeName);
    }

    public List<BoundaryType> getNonRootBoundaryTypesByHierarchyType(HierarchyType hierarchyType) {
        return this.boundaryTypeRepository.findAllByHierarchyTypeWhenParentIsNotNull(hierarchyType);
    }

    public List<BoundaryType> getBoundaryTypeByHierarchyTypeName(String name) {
        return this.boundaryTypeRepository.findByHierarchyTypeName(name);
    }
}

