/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.repository.BoundaryRepository;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.StringUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BoundaryService {
    private static final Logger LOG = LoggerFactory.getLogger(BoundaryService.class);
    private final BoundaryRepository boundaryRepository;
    @Autowired
    private CrossHierarchyService crossHierarchyService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;

    @Autowired
    public BoundaryService(BoundaryRepository boundaryRepository) {
        this.boundaryRepository = boundaryRepository;
    }

    @Transactional
    public Boundary createBoundary(Boundary boundary) {
        return (Boundary)this.boundaryRepository.save(boundary);
    }

    @Transactional
    public void updateBoundary(Boundary boundary) {
        this.boundaryRepository.save(boundary);
    }

    public Boundary getBoundaryById(Long id) {
        return (Boundary)this.boundaryRepository.findOne(id);
    }

    public Boundary getBoundaryByName(String name) {
        return this.boundaryRepository.findByName(name);
    }

    public List<Boundary> getAllBoundaries() {
        return this.boundaryRepository.findAll();
    }

    public List<Boundary> getBoundaryByNameLike(String name) {
        return this.boundaryRepository.findByNameContainingIgnoreCase(name);
    }

    public List<Boundary> getAllBoundariesByBoundaryTypeId(Long boundaryTypeId) {
        return this.boundaryRepository.findBoundariesByBoundaryType(boundaryTypeId);
    }

    public List<Boundary> getPageOfBoundaries(Long boundaryTypeId) {
        return this.boundaryRepository.findBoundariesByBoundaryType(boundaryTypeId);
    }

    public Boundary getBoundaryByTypeAndNo(BoundaryType boundaryType, Long boundaryNum) {
        return this.boundaryRepository.findBoundarieByBoundaryTypeAndBoundaryNum(boundaryType, boundaryNum);
    }

    public List<Boundary> getParentBoundariesByBoundaryId(Long boundaryId) {
        List<Boundary> boundaryList = new ArrayList<Boundary>();
        Boundary bndry = this.getBoundaryById(boundaryId);
        if (bndry != null) {
            boundaryList.add(bndry);
            if (bndry.getParent() != null) {
                boundaryList = this.getParentBoundariesByBoundaryId(bndry.getParent().getId());
            }
        }
        return boundaryList;
    }

    public Map<String, List<Boundary>> getSecondLevelBoundaryByHierarchyType(HierarchyType hierarchyType) {
        List<Object> boundaryList = new ArrayList();
        HashMap<String, List<Boundary>> boundaryMap = new HashMap<String, List<Boundary>>();
        boundaryList = this.boundaryRepository.findActiveBoundariesByHierarchyTypeAndLevelAndAsOnDate(hierarchyType, 2L, new Date());
        String bryName = null;
        for (Boundary boundary : boundaryList) {
            bryName = boundary.getBoundaryType().getName();
        }
        if (bryName != null) {
            boundaryMap.put(bryName, boundaryList);
        }
        return boundaryMap;
    }

    public Boundary getActiveBoundaryByIdAsOnCurrentDate(Long id) {
        return this.boundaryRepository.findActiveBoundaryByIdAndAsOnDate(id, new Date());
    }

    public Boundary getActiveBoundaryById(Long id) {
        return this.boundaryRepository.findActiveBoundaryById(id);
    }

    public List<Boundary> getActiveBoundariesByBoundaryTypeId(Long boundaryTypeId) {
        return this.boundaryRepository.findActiveBoundariesByBoundaryTypeId(boundaryTypeId);
    }

    public List<Boundary> getTopLevelBoundaryByHierarchyType(HierarchyType hierarchyType) {
        return this.boundaryRepository.findActiveBoundariesByHierarchyTypeAndLevelAndAsOnDate(hierarchyType, 1L, new Date());
    }

    public List<Boundary> getActiveChildBoundariesByBoundaryId(Long boundaryId) {
        return this.boundaryRepository.findActiveChildBoundariesByBoundaryIdAndAsOnDate(boundaryId, new Date());
    }

    public List<Boundary> getChildBoundariesByBoundaryId(Long boundaryId) {
        return this.boundaryRepository.findChildBoundariesByBoundaryIdAndAsOnDate(boundaryId, new Date());
    }

    public Boundary getActiveBoundaryByBndryNumAndTypeAndHierarchyTypeCode(Long bndryNum, String boundaryType, String hierarchyTypeCode) {
        return this.boundaryRepository.findActiveBoundaryByBndryNumAndTypeAndHierarchyTypeCodeAndAsOnDate(bndryNum, boundaryType, hierarchyTypeCode, new Date());
    }

    public List<Boundary> getActiveBoundariesByBndryTypeNameAndHierarchyTypeName(String boundaryTypeName, String hierarchyTypeName) {
        return this.boundaryRepository.findActiveBoundariesByBndryTypeNameAndHierarchyTypeName(boundaryTypeName, hierarchyTypeName);
    }

    public List<Boundary> getBoundariesByBndryTypeNameAndHierarchyTypeName(String boundaryTypeName, String hierarchyTypeName) {
        return this.boundaryRepository.findBoundariesByBndryTypeNameAndHierarchyTypeName(boundaryTypeName, hierarchyTypeName);
    }

    public Boundary getBoundaryByBndryTypeNameAndHierarchyTypeName(String boundaryTypeName, String hierarchyTypeName) {
        return this.boundaryRepository.findBoundaryByBndryTypeNameAndHierarchyTypeName(boundaryTypeName, hierarchyTypeName);
    }

    public List<Boundary> getBondariesByNameAndType(String boundaryName, Long boundaryTypeId) {
        return this.boundaryRepository.findByNameAndBoundaryType(boundaryName, boundaryTypeId);
    }

    public Boolean validateBoundary(BoundaryType boundaryType) {
        Boundary bndry = this.boundaryRepository.findByBoundaryTypeNameAndHierarchyTypeNameAndLevel(boundaryType.getName(), boundaryType.getHierarchyType().getName(), 1L);
        if (bndry != null) {
            return true;
        }
        return false;
    }

    public List<Boundary> getBondariesByNameAndBndryTypeAndHierarchyType(String boundaryTypeName, String hierarchyTypeName, String name) {
        return this.boundaryRepository.findActiveBoundariesByNameAndBndryTypeNameAndHierarchyTypeName(boundaryTypeName, hierarchyTypeName, name);
    }

    public List<Map<String, Object>> getBoundaryDataByNameLike(String name) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.crossHierarchyService.getChildBoundaryNameAndBndryTypeAndHierarchyType("Locality", "Location", "Administration", '%' + name + '%').stream().forEach(location -> {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("id", location.getId());
            res.put("name", location.getChild().getName() + " - " + location.getParent().getName());
            list.add(res);
        });
        return list;
    }

    public List<Boundary> findActiveChildrenWithParent(Long parentBoundaryId) {
        return this.boundaryRepository.findActiveChildrenWithParent(parentBoundaryId);
    }

    public List<Boundary> findActiveBoundariesForMpath(Set<String> mpath) {
        return this.boundaryRepository.findActiveBoundariesForMpath(mpath);
    }

    public List<Boundary> findAllChildrenWithoutParent(Long parentBoundaryId) {
        return this.boundaryRepository.findAllChildrenWithOutParent(parentBoundaryId);
    }

    public List<Boundary> findActiveChildrenWitouthParent(Long parentBoundaryId) {
        return this.boundaryRepository.findActiveChildrenWithOutParent(parentBoundaryId);
    }

    public List<Boundary> findActiveImmediateChildrenWithOutParent(Long parentBoudaryId) {
        return this.boundaryRepository.findActiveImmediateChildrenWithOutParent(parentBoudaryId);
    }

    public List<Boundary> findAllParents() {
        return this.boundaryRepository.findAllParents();
    }

    public String getMaterializedPath(Boundary child, Boundary parent) {
        String mpath = "";
        int childSize = 0;
        if (null == parent) {
            mpath = String.valueOf(this.boundaryRepository.findAllParents().size() + 1);
        } else {
            childSize = this.boundaryRepository.findActiveImmediateChildrenWithOutParent(parent.getId()).size();
        }
        if (mpath.isEmpty()) {
            mpath = null != child ? (!child.getMaterializedPath().equalsIgnoreCase(parent.getMaterializedPath() + "." + childSize) ? parent.getMaterializedPath() + "." + ++childSize : child.getMaterializedPath()) : parent.getMaterializedPath() + "." + ++childSize;
        }
        return mpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getBndryIdFromShapefile(Double latitude, Double longitude) {
        try {
            Long boundaryId = 0L;
            if (latitude != null && longitude != null) {
                HashMap<String, URL> map = new HashMap<String, URL>();
                map.put("url", Thread.currentThread().getContextClassLoader().getResource("gis/" + ApplicationThreadLocals.getTenantID() + "/wards.shp"));
                DataStore dataStore = DataStoreFinder.getDataStore(map);
                FeatureCollection collection = dataStore.getFeatureSource(dataStore.getTypeNames()[0]).getFeatures();
                Iterator iterator = collection.iterator();
                Point point = JTSFactoryFinder.getGeometryFactory(null).createPoint(new Coordinate(longitude.doubleValue(), latitude.doubleValue()));
                LOG.debug("Fetching boundary data for coordinates lng {}, lat {}", (Object)longitude, (Object)latitude);
                try {
                    while (iterator.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        Geometry geom = (Geometry)feature.getDefaultGeometry();
                        if (!geom.contains((Geometry)point)) continue;
                        LOG.debug("Found coordinates in shape file");
                        Long boundaryNum = (Long)feature.getAttribute("bndrynum");
                        String bndryType = (String)feature.getAttribute("bndrytype");
                        LOG.debug("Got boundary number {} and boundary type {} from GIS", (Object)boundaryNum, (Object)bndryType);
                        if (boundaryNum != null && StringUtils.isNotBlank((String)bndryType)) {
                            BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyTypeName(bndryType, "ADMINISTRATION");
                            Boundary boundary = this.getBoundaryByTypeAndNo(boundaryType, boundaryNum);
                            if (boundary != null) {
                                boundaryId = boundary.getId();
                            } else {
                                BoundaryType cityBoundaryType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyTypeName("City", "ADMINISTRATION");
                                Boundary cityBoundary = this.getAllBoundariesByBoundaryTypeId(cityBoundaryType.getId()).get(0);
                                boundaryId = cityBoundary.getId();
                            }
                        }
                        break;
                    }
                }
                finally {
                    collection.close(iterator);
                }
            }
            LOG.debug("Found boundary data in GIS with boundary id : {}", (Object)boundaryId);
            return boundaryId;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occurred while fetching boundary from GIS data", e);
        }
    }
}

