/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.List;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.repository.AppConfigRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AppConfigService {
    private final AppConfigRepository appConfigValueRepository;

    @Autowired
    public AppConfigService(AppConfigRepository appConfigValueRepos) {
        this.appConfigValueRepository = appConfigValueRepos;
    }

    public AppConfig findBykeyNameAndModuleName(Long keyId, Long moduleId) {
        return this.appConfigValueRepository.findByIdAndModule_Id(keyId, moduleId);
    }

    public AppConfig findBykeyName(String keyName) {
        return this.appConfigValueRepository.findBykeyName(keyName);
    }

    public AppConfig findById(Long appId) {
        return this.appConfigValueRepository.findById(appId);
    }

    public List<Module> findByNameContainingIgnoreCase(String likemoduleName) {
        return this.appConfigValueRepository.findByNameContainingIgnoreCase(likemoduleName);
    }

    public Module findByModuleById(Long moduleId) {
        return this.appConfigValueRepository.findByModuleById(moduleId);
    }

    public List<AppConfig> findAll() {
        return this.appConfigValueRepository.findAll();
    }

    public List<AppConfig> findAllByModule(Long module) {
        return this.appConfigValueRepository.findByModule_Id(module);
    }

    public Page<AppConfig> getListOfAppConfig(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"module.name"});
        return this.appConfigValueRepository.findAll((Pageable)pageable);
    }

    public List<Module> findAllModules() {
        return this.appConfigValueRepository.findAllModules();
    }

    @Transactional
    public void createAppConfigValues(AppConfig appConfig) {
        this.appConfigValueRepository.save(appConfig);
    }

    @Transactional
    public void updateAppConfigValues(AppConfig appConfig) {
        this.appConfigValueRepository.save(appConfig);
    }

    public AppConfig getConfigKeyByName(String keyName, String moduleName) {
        return this.appConfigValueRepository.findByKeyNameAndModule_Name(keyName, moduleName);
    }

    public List<AppConfig> getAppConfigKeys(String moduleName) {
        return this.appConfigValueRepository.findByModule_Name(moduleName);
    }

    public List<String> getAllAppConfigModule() {
        return this.appConfigValueRepository.getAllAppConfigModule();
    }
}

